/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetS3TargetReadPreferenceSpectraS3Response;
import com.spectralogic.ds3client.models.S3TargetReadPreference;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetS3TargetReadPreferenceSpectraS3ResponseParser
extends AbstractResponseParser<GetS3TargetReadPreferenceSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetS3TargetReadPreferenceSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        S3TargetReadPreference result = XmlOutput.fromXml(inputStream, S3TargetReadPreference.class);
                        GetS3TargetReadPreferenceSpectraS3Response getS3TargetReadPreferenceSpectraS3Response = new GetS3TargetReadPreferenceSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getS3TargetReadPreferenceSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

