/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.DataReplicationRuleType;
import com.spectralogic.ds3client.networking.HttpVerb;

public class ModifyAzureDataReplicationRuleSpectraS3Request
extends AbstractRequest {
    private final String azureDataReplicationRule;
    private long maxBlobPartSizeInBytes;
    private boolean replicateDeletes;
    private DataReplicationRuleType type;

    public ModifyAzureDataReplicationRuleSpectraS3Request(String azureDataReplicationRule) {
        this.azureDataReplicationRule = azureDataReplicationRule;
    }

    public ModifyAzureDataReplicationRuleSpectraS3Request withMaxBlobPartSizeInBytes(long maxBlobPartSizeInBytes) {
        this.maxBlobPartSizeInBytes = maxBlobPartSizeInBytes;
        this.updateQueryParam("max_blob_part_size_in_bytes", maxBlobPartSizeInBytes);
        return this;
    }

    public ModifyAzureDataReplicationRuleSpectraS3Request withReplicateDeletes(boolean replicateDeletes) {
        this.replicateDeletes = replicateDeletes;
        this.updateQueryParam("replicate_deletes", replicateDeletes);
        return this;
    }

    public ModifyAzureDataReplicationRuleSpectraS3Request withType(DataReplicationRuleType type) {
        this.type = type;
        this.updateQueryParam("type", type);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/azure_data_replication_rule/" + this.azureDataReplicationRule;
    }

    public String getAzureDataReplicationRule() {
        return this.azureDataReplicationRule;
    }

    public long getMaxBlobPartSizeInBytes() {
        return this.maxBlobPartSizeInBytes;
    }

    public boolean getReplicateDeletes() {
        return this.replicateDeletes;
    }

    public DataReplicationRuleType getType() {
        return this.type;
    }
}

