/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;

public class ModifyCacheFilesystemSpectraS3Request
extends AbstractRequest {
    private final String cacheFilesystem;
    private double autoReclaimInitiateThreshold;
    private double autoReclaimTerminateThreshold;
    private double burstThreshold;
    private Long maxCapacityInBytes;

    public ModifyCacheFilesystemSpectraS3Request(String cacheFilesystem) {
        this.cacheFilesystem = cacheFilesystem;
    }

    public ModifyCacheFilesystemSpectraS3Request withAutoReclaimInitiateThreshold(double autoReclaimInitiateThreshold) {
        this.autoReclaimInitiateThreshold = autoReclaimInitiateThreshold;
        this.updateQueryParam("auto_reclaim_initiate_threshold", autoReclaimInitiateThreshold);
        return this;
    }

    public ModifyCacheFilesystemSpectraS3Request withAutoReclaimTerminateThreshold(double autoReclaimTerminateThreshold) {
        this.autoReclaimTerminateThreshold = autoReclaimTerminateThreshold;
        this.updateQueryParam("auto_reclaim_terminate_threshold", autoReclaimTerminateThreshold);
        return this;
    }

    public ModifyCacheFilesystemSpectraS3Request withBurstThreshold(double burstThreshold) {
        this.burstThreshold = burstThreshold;
        this.updateQueryParam("burst_threshold", burstThreshold);
        return this;
    }

    public ModifyCacheFilesystemSpectraS3Request withMaxCapacityInBytes(Long maxCapacityInBytes) {
        this.maxCapacityInBytes = maxCapacityInBytes;
        this.updateQueryParam("max_capacity_in_bytes", maxCapacityInBytes);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/cache_filesystem/" + this.cacheFilesystem;
    }

    public String getCacheFilesystem() {
        return this.cacheFilesystem;
    }

    public double getAutoReclaimInitiateThreshold() {
        return this.autoReclaimInitiateThreshold;
    }

    public double getAutoReclaimTerminateThreshold() {
        return this.autoReclaimTerminateThreshold;
    }

    public double getBurstThreshold() {
        return this.burstThreshold;
    }

    public Long getMaxCapacityInBytes() {
        return this.maxCapacityInBytes;
    }
}

