/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Quiesced;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class ModifyPoolSpectraS3Request
extends AbstractRequest {
    private final String pool;
    private String partitionId;
    private Quiesced quiesced;

    public ModifyPoolSpectraS3Request(String pool) {
        this.pool = pool;
    }

    public ModifyPoolSpectraS3Request withPartitionId(UUID partitionId) {
        this.partitionId = partitionId.toString();
        this.updateQueryParam("partition_id", partitionId);
        return this;
    }

    public ModifyPoolSpectraS3Request withPartitionId(String partitionId) {
        this.partitionId = partitionId;
        this.updateQueryParam("partition_id", partitionId);
        return this;
    }

    public ModifyPoolSpectraS3Request withQuiesced(Quiesced quiesced) {
        this.quiesced = quiesced;
        this.updateQueryParam("quiesced", quiesced);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/pool/" + this.pool;
    }

    public String getPool() {
        return this.pool;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public Quiesced getQuiesced() {
        return this.quiesced;
    }
}

