/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.BulkCommand;
import com.spectralogic.ds3client.commands.interfaces.BulkRequest;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.models.bulk.Ds3Object;

public class PutBulkJobSpectraS3Request
extends BulkRequest {
    private static final String MAX_UPLOAD_SIZE_IN_BYTES = "100000000000";
    public static final int MIN_UPLOAD_SIZE_IN_BYTES = 0xA00000;
    private boolean aggregating;
    private boolean force;
    private boolean ignoreNamingConflicts;
    private boolean implicitJobIdResolution;
    private boolean minimizeSpanningAcrossMedia;
    private String name;
    private boolean verifyAfterWrite;

    public PutBulkJobSpectraS3Request(String bucketName, Iterable<Ds3Object> objects) {
        super(bucketName, objects);
        this.getQueryParams().put("operation", "start_bulk_put");
    }

    public PutBulkJobSpectraS3Request withAggregating(boolean aggregating) {
        this.aggregating = aggregating;
        this.updateQueryParam("aggregating", aggregating);
        return this;
    }

    public PutBulkJobSpectraS3Request withForce(boolean force) {
        this.force = force;
        if (this.force) {
            this.getQueryParams().put("force", null);
        } else {
            this.getQueryParams().remove("force");
        }
        return this;
    }

    public PutBulkJobSpectraS3Request withIgnoreNamingConflicts(boolean ignoreNamingConflicts) {
        this.ignoreNamingConflicts = ignoreNamingConflicts;
        if (this.ignoreNamingConflicts) {
            this.getQueryParams().put("ignore_naming_conflicts", null);
        } else {
            this.getQueryParams().remove("ignore_naming_conflicts");
        }
        return this;
    }

    public PutBulkJobSpectraS3Request withImplicitJobIdResolution(boolean implicitJobIdResolution) {
        this.implicitJobIdResolution = implicitJobIdResolution;
        this.updateQueryParam("implicit_job_id_resolution", implicitJobIdResolution);
        return this;
    }

    public PutBulkJobSpectraS3Request withMaxUploadSize(long maxUploadSize) {
        if (maxUploadSize >= 0xA00000L) {
            this.getQueryParams().put("max_upload_size", Long.toString(maxUploadSize));
        } else {
            this.getQueryParams().put("max_upload_size", MAX_UPLOAD_SIZE_IN_BYTES);
        }
        return this;
    }

    public PutBulkJobSpectraS3Request withMinimizeSpanningAcrossMedia(boolean minimizeSpanningAcrossMedia) {
        this.minimizeSpanningAcrossMedia = minimizeSpanningAcrossMedia;
        this.updateQueryParam("minimize_spanning_across_media", minimizeSpanningAcrossMedia);
        return this;
    }

    public PutBulkJobSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    @Override
    public PutBulkJobSpectraS3Request withPriority(Priority priority) {
        super.withPriority(priority);
        return this;
    }

    public PutBulkJobSpectraS3Request withVerifyAfterWrite(boolean verifyAfterWrite) {
        this.verifyAfterWrite = verifyAfterWrite;
        this.updateQueryParam("verify_after_write", verifyAfterWrite);
        return this;
    }

    public boolean getAggregating() {
        return this.aggregating;
    }

    public boolean getForce() {
        return this.force;
    }

    public boolean getIgnoreNamingConflicts() {
        return this.ignoreNamingConflicts;
    }

    public boolean getImplicitJobIdResolution() {
        return this.implicitJobIdResolution;
    }

    public boolean getMinimizeSpanningAcrossMedia() {
        return this.minimizeSpanningAcrossMedia;
    }

    public String getName() {
        return this.name;
    }

    public boolean getVerifyAfterWrite() {
        return this.verifyAfterWrite;
    }

    @Override
    public BulkCommand getCommand() {
        return BulkCommand.PUT;
    }
}

