/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import java.io.IOException;

public class ObjectStorageSpaceVerificationResult {
    private final VerificationStatus verificationStatus;
    private final long requiredSpace;
    private final long availableSpace;
    private final boolean containsSufficientSpace;
    private final IOException ioException;

    public ObjectStorageSpaceVerificationResult(VerificationStatus verificationStatus, long requiredSpace, long availableSpace, IOException ioException) {
        this.requiredSpace = requiredSpace;
        this.availableSpace = availableSpace;
        this.containsSufficientSpace = availableSpace > requiredSpace;
        this.verificationStatus = verificationStatus;
        this.ioException = ioException;
    }

    public VerificationStatus getVerificationStatus() {
        return this.verificationStatus;
    }

    public long getRequiredSpace() {
        return this.requiredSpace;
    }

    public long getAvailableSpace() {
        return this.availableSpace;
    }

    public boolean containsSufficientSpace() {
        return this.containsSufficientSpace;
    }

    public IOException getIoException() {
        return this.ioException;
    }

    public String toString() {
        return "ObjectStorageSpaceVerificationResult { verificationStatus = " + (Object)((Object)this.verificationStatus) + ", requiredSpace = " + this.requiredSpace + ", availableSpace = " + this.availableSpace + ", containsSufficientSpace = " + this.containsSufficientSpace + ", ioException = " + this.ioException + '}';
    }

    public static enum VerificationStatus {
        OK,
        PathIsNotADirectory,
        PathDoesNotExist,
        PathLacksAccess,
        PathLacksSufficientStorageSpace,
        BucketDoesNotExist,
        CaughtIOException;

    }
}

