/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.networking;

import com.spectralogic.ds3client.models.ChecksumType;
import com.spectralogic.ds3client.utils.hashing.CRC32CHasher;
import com.spectralogic.ds3client.utils.hashing.CRC32Hasher;
import com.spectralogic.ds3client.utils.hashing.Hasher;
import com.spectralogic.ds3client.utils.hashing.MD5Hasher;
import com.spectralogic.ds3client.utils.hashing.SHA256Hasher;
import com.spectralogic.ds3client.utils.hashing.SHA512Hasher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

class HashGeneratingMatchHandler
implements ChecksumType.MatchHandler<String, IOException> {
    private static final int READ_BUFFER_SIZE = 1024;
    private final InputStream content;
    private final ChecksumType.Type checksumType;
    private final int bufferSize;

    public HashGeneratingMatchHandler(InputStream content, ChecksumType.Type checksumType) {
        this(content, checksumType, 1024);
    }

    public HashGeneratingMatchHandler(InputStream content, ChecksumType.Type checksumType, int bufferSize) {
        this.content = content;
        this.checksumType = checksumType;
        this.bufferSize = bufferSize;
    }

    @Override
    public String none() throws IOException {
        return "";
    }

    @Override
    public String compute() throws IOException {
        return this.hashInputStream(this.getHasher(this.checksumType), this.content);
    }

    @Override
    public String value(byte[] hash) throws IOException {
        return new String(hash, Charset.forName("UTF-8"));
    }

    private String hashInputStream(Hasher digest, InputStream stream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[this.bufferSize];
        while ((bytesRead = stream.read(buffer)) >= 0) {
            digest.update(buffer, 0, bytesRead);
        }
        return digest.digest();
    }

    private Hasher getHasher(ChecksumType.Type checksumType) {
        switch (checksumType) {
            case MD5: {
                return new MD5Hasher();
            }
            case SHA_256: {
                return new SHA256Hasher();
            }
            case SHA_512: {
                return new SHA512Hasher();
            }
            case CRC_32: {
                return new CRC32Hasher();
            }
            case CRC_32C: {
                return new CRC32CHasher();
            }
        }
        throw new RuntimeException("Unknown checksum type " + checksumType.toString());
    }
}

