/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils.hashing;

import com.spectralogic.ds3client.utils.InvalidMd5Exception;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class Md5Hash {
    private final byte[] hash;

    public static Md5Hash fromHexString(String hex) throws InvalidMd5Exception {
        try {
            return new Md5Hash(Hex.decodeHex((char[])hex.toCharArray()));
        }
        catch (DecoderException e) {
            throw new InvalidMd5Exception(e);
        }
    }

    public static Md5Hash fromBase64String(String base64) {
        return new Md5Hash(Base64.decodeBase64((String)base64));
    }

    public static Md5Hash fromByteArray(byte[] bytes) {
        return new Md5Hash(bytes);
    }

    private Md5Hash(byte[] hash) {
        this.hash = hash;
    }

    public byte[] getHash() {
        return Arrays.copyOfRange(this.hash, 0, this.hash.length);
    }

    public String toHexString() {
        return Hex.encodeHexString((byte[])this.hash);
    }

    public String toBase64String() {
        return Base64.encodeBase64String((byte[])this.hash);
    }

    public String toString() {
        return this.toBase64String();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hash});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Md5Hash)) {
            return false;
        }
        Md5Hash otherHash = (Md5Hash)obj;
        return Arrays.equals(this.hash, otherHash.getHash());
    }
}

