/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.DefaultSocketExceptionMappingService;
import ch.cyberduck.core.ExceptionMappingService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.ConnectionRefusedException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.ResolveFailedException;
import java.io.EOFException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.NoHttpResponseException;
import org.apache.log4j.Logger;

public abstract class AbstractExceptionMappingService<T extends Throwable>
implements ExceptionMappingService<T> {
    private static final Logger log = Logger.getLogger(AbstractExceptionMappingService.class);

    public BackgroundException map(String message, T failure) {
        BackgroundException exception = this.map(failure);
        StringBuilder m = new StringBuilder();
        this.append(m, StringUtils.chomp((String)LocaleFactory.localizedString(message, "Error")));
        exception.setMessage(m.toString());
        return exception;
    }

    public BackgroundException map(String message, T failure, Path file) {
        BackgroundException exception = this.map(failure);
        StringBuilder m = new StringBuilder();
        String formatted = MessageFormat.format(StringUtils.chomp((String)LocaleFactory.localizedString(message, "Error")), file.getName());
        if (StringUtils.contains((CharSequence)formatted, (CharSequence)String.format("%s ", file.getName())) || StringUtils.contains((CharSequence)formatted, (CharSequence)String.format(" %s", file.getName()))) {
            this.append(m, formatted);
        } else {
            this.append(m, String.format("%s (%s)", MessageFormat.format(StringUtils.chomp((String)LocaleFactory.localizedString(message, "Error")), file.getName()), file.getAbsolute()));
        }
        exception.setMessage(m.toString());
        exception.setFile(file);
        return exception;
    }

    @Override
    public abstract BackgroundException map(T var1);

    public StringBuilder append(StringBuilder buffer, String message) {
        StringAppender appender = new StringAppender(buffer);
        appender.append(StringUtils.capitalize((String)message));
        return buffer;
    }

    protected BackgroundException wrap(T failure, StringBuilder buffer) {
        return this.wrap(failure, LocaleFactory.localizedString("Connection failed", "Error"), buffer);
    }

    protected BackgroundException wrap(T failure, String title, StringBuilder buffer) {
        if (buffer.toString().isEmpty()) {
            log.warn((Object)String.format("No message for failure %s", failure));
            this.append(buffer, LocaleFactory.localizedString("Interoperability failure", "Error"));
        }
        for (Throwable cause : ExceptionUtils.getThrowableList(failure)) {
            if (cause instanceof InterruptedIOException) {
                return new ConnectionTimeoutException(buffer.toString(), (Throwable)failure);
            }
            if (cause instanceof TimeoutException) {
                return new ConnectionTimeoutException(buffer.toString(), (Throwable)failure);
            }
            if (cause instanceof SocketException) {
                return new DefaultSocketExceptionMappingService().map((SocketException)cause);
            }
            if (cause instanceof EOFException) {
                return new ConnectionRefusedException(buffer.toString(), (Throwable)failure);
            }
            if (cause instanceof UnknownHostException) {
                return new ResolveFailedException(buffer.toString(), (Throwable)failure);
            }
            if (cause instanceof NoHttpResponseException) {
                return new ConnectionRefusedException(buffer.toString(), (Throwable)failure);
            }
            if (!(cause instanceof InterruptedException)) continue;
            return new ConnectionCanceledException(buffer.toString(), (Throwable)failure);
        }
        return new BackgroundException(title, buffer.toString(), (Throwable)failure);
    }
}

