/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.EditableCollection;
import ch.cyberduck.core.FolderBookmarkCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.text.NaturalOrderComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractHostCollection
extends Collection<Host>
implements EditableCollection {
    private static final long serialVersionUID = -255801158019850767L;
    private static final Logger log = Logger.getLogger(AbstractHostCollection.class);
    private static final AbstractHostCollection EMPTY = new AbstractHostCollection(){
        private static final long serialVersionUID = -8444415684736364173L;

        @Override
        public String getName() {
            return LocaleFactory.localizedString("None");
        }
    };
    private final Comparator<String> comparator = new NaturalOrderComparator();

    public static AbstractHostCollection empty() {
        return EMPTY;
    }

    public AbstractHostCollection() {
    }

    public AbstractHostCollection(java.util.Collection<Host> c) {
        super(c);
    }

    public abstract String getName();

    public String getComment(Host h) {
        if (StringUtils.isNotBlank((CharSequence)h.getComment())) {
            return StringUtils.remove((String)StringUtils.remove((String)h.getComment(), (char)'\n'), (char)'\r');
        }
        return null;
    }

    @Override
    public boolean addAll(java.util.Collection<? extends Host> c) {
        ArrayList<Host> temporary = new ArrayList<Host>();
        for (Host host : c) {
            if (temporary.contains(host)) {
                log.warn((Object)String.format("Skip adding duplicate bookmark %s", host));
                continue;
            }
            temporary.add(host);
        }
        return super.addAll(temporary);
    }

    @Override
    public boolean add(Host host) {
        if (this.contains(host)) {
            log.warn((Object)String.format("Skip adding duplicate bookmark %s", host));
            return false;
        }
        return super.add(host);
    }

    @Override
    public void add(int row, Host host) {
        if (this.contains(host)) {
            log.warn((Object)String.format("Skip adding duplicate bookmark %s", host));
            return;
        }
        super.add(row, host);
    }

    @Override
    public void collectionItemAdded(Host item) {
        if (this.isLocked()) {
            log.debug((Object)"Skip sorting bookmark collection while loading");
        } else {
            this.sort();
        }
        super.collectionItemAdded(item);
    }

    @Override
    public void collectionItemRemoved(Host item) {
        if (this.isLocked()) {
            log.debug((Object)"Skip sorting bookmark collection while loading");
        } else {
            this.sort();
        }
        super.collectionItemRemoved(item);
    }

    public synchronized void sortByNickname() {
        this.doSort(new Comparator<Host>(){

            @Override
            public int compare(Host o1, Host o2) {
                return AbstractHostCollection.this.comparator.compare(BookmarkNameProvider.toString(o1), BookmarkNameProvider.toString(o2));
            }
        });
    }

    public synchronized void sortByHostname() {
        this.doSort(new Comparator<Host>(){

            @Override
            public int compare(Host o1, Host o2) {
                return AbstractHostCollection.this.comparator.compare(o1.getHostname(), o2.getHostname());
            }
        });
    }

    public synchronized void sortByProtocol() {
        this.doSort(new Comparator<Host>(){

            @Override
            public int compare(Host o1, Host o2) {
                return AbstractHostCollection.this.comparator.compare(o1.getProtocol().getIdentifier(), o2.getProtocol().getIdentifier());
            }
        });
    }

    public synchronized void doSort(Comparator<Host> comparator) {
        Collections.sort(FolderBookmarkCollection.favoritesCollection(), comparator);
        this.save();
    }

    protected void sort() {
    }

    public Host lookup(String uuid) {
        return this.stream().filter(h -> h.getUuid().equals(uuid)).findFirst().orElse(null);
    }

    @Override
    public boolean allowsAdd() {
        return true;
    }

    @Override
    public boolean allowsDelete() {
        return true;
    }

    @Override
    public boolean allowsEdit() {
        return true;
    }

    public void save() {
    }

    protected void load(Collection<Host> c) {
        this.addAll((java.util.Collection<? extends Host>)c);
        this.collectionLoaded();
    }

    public boolean find(Host bookmark) {
        return this.stream().anyMatch(h -> h.compareTo(bookmark) == 0);
    }
}

