/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.DisabledAlertCallback;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class AlertCallbackFactory
extends Factory<AlertCallback> {
    private static final Logger log = Logger.getLogger(AlertCallbackFactory.class);
    private static final AlertCallbackFactory factory = new AlertCallbackFactory();
    private Constructor<AlertCallback> constructor;

    protected AlertCallbackFactory() {
        super("factory.alertcallback.class");
    }

    public AlertCallback create(Controller controller) {
        try {
            if (null == this.constructor) {
                this.constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{controller.getClass()});
            }
            if (null == this.constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", controller.getClass()));
                return (AlertCallback)this.clazz.newInstance();
            }
            return this.constructor.newInstance(controller);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
            return new DisabledAlertCallback();
        }
    }

    public static AlertCallback get(Controller c) {
        return factory.create(c);
    }
}

