/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.preferences.PreferencesFactory;

public abstract class Factory<T> {
    protected final Class<T> clazz;

    protected Factory() {
        this.clazz = null;
    }

    protected Factory(String name) {
        try {
            String c = PreferencesFactory.get().getProperty(name);
            if (null == c) {
                throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
            }
            this.clazz = Class.forName(c);
        }
        catch (ClassNotFoundException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    protected T create() {
        if (null == this.clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            return this.clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    public static enum Platform {
        osname{

            public String toString() {
                return System.getProperty("os.name");
            }
        }
        ,
        osversion{

            public String toString() {
                return System.getProperty("os.version");
            }
        };


        public boolean matches(String regex) {
            return this.toString().matches(regex);
        }

        public static Name getDefault() {
            if (osname.matches(".*Linux.*")) {
                return Name.linux;
            }
            if (osname.matches(".*Windows.*")) {
                return Name.windows;
            }
            if (osname.matches(".*Mac.*")) {
                return Name.mac;
            }
            return Name.unknown;
        }

        public static enum Name {
            mac,
            windows,
            linux,
            unknown;

        }
    }
}

