/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractFolderHostCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class HistoryCollection
extends AbstractFolderHostCollection {
    private static final long serialVersionUID = 2270155702956300755L;
    private static final HistoryCollection HISTORY_COLLECTION = new HistoryCollection(LocalFactory.get(SupportDirectoryFinderFactory.get().find(), "History"));

    public HistoryCollection(Local f) {
        super(f);
    }

    public static HistoryCollection defaultCollection() {
        return HISTORY_COLLECTION;
    }

    @Override
    public Local getFile(Host bookmark) {
        return LocalFactory.get(this.folder, String.format("%s.duck", StringUtils.replace((String)BookmarkNameProvider.toString(bookmark), (String)"/", (String)":")));
    }

    @Override
    public String getComment(Host host) {
        Date timestamp = host.getTimestamp();
        if (null != timestamp) {
            return UserDateFormatterFactory.get().getLongFormat(timestamp.getTime());
        }
        return null;
    }

    @Override
    public void add(int row, Host bookmark) {
        if (this.contains(bookmark)) {
            this.remove(bookmark);
        }
        super.add(row, bookmark);
    }

    @Override
    public boolean add(Host bookmark) {
        if (this.contains(bookmark)) {
            this.remove(bookmark);
        }
        return super.add(bookmark);
    }

    @Override
    protected synchronized void sort() {
        Collections.sort(this, new Comparator<Host>(){

            @Override
            public int compare(Host o1, Host o2) {
                if (null == o1.getTimestamp() && null == o2.getTimestamp()) {
                    return 0;
                }
                if (null == o1.getTimestamp()) {
                    return 1;
                }
                if (null == o2.getTimestamp()) {
                    return -1;
                }
                return -o1.getTimestamp().compareTo(o2.getTimestamp());
            }
        });
    }

    @Override
    public boolean allowsAdd() {
        return false;
    }

    @Override
    public boolean allowsEdit() {
        return false;
    }
}

