/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.identity;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.identity.AbstractIdentityConfiguration;
import org.apache.commons.lang3.StringUtils;

public class DefaultCredentialsIdentityConfiguration
extends AbstractIdentityConfiguration {
    private final Host host;
    private final PasswordStore store;

    public DefaultCredentialsIdentityConfiguration(Host host) {
        this.host = host;
        this.store = PasswordStoreFactory.get();
    }

    public DefaultCredentialsIdentityConfiguration(Host host, PasswordStore store) {
        this.host = host;
        this.store = store;
    }

    @Override
    public Credentials getCredentials(String username) {
        String user = this.host.getCredentials().getUsername();
        String password = this.store.getPassword(this.host.getProtocol().getScheme(), this.host.getPort(), this.host.getHostname(), user);
        if (StringUtils.isEmpty((CharSequence)password)) {
            return null;
        }
        return new Credentials(user, password);
    }
}

