/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.EnumSet;

public abstract class DefaultAclFeature
implements AclPermission {
    private final Preferences preferences = PreferencesFactory.get();

    @Override
    public Acl getDefault(EnumSet<AbstractPath.Type> type) {
        if (this.preferences.getBoolean("queue.upload.permissions.default")) {
            if (type.contains((Object)AbstractPath.Type.file)) {
                return this.toAcl(new Permission(this.preferences.getInteger("queue.upload.permissions.file.default")));
            }
            return this.toAcl(new Permission(this.preferences.getInteger("queue.upload.permissions.folder.default")));
        }
        return Acl.EMPTY;
    }

    @Override
    public Acl getDefault(Local file) {
        if (this.preferences.getBoolean("queue.upload.permissions.default")) {
            return this.getDefault(file.getType());
        }
        return this.toAcl(file.attributes().getPermission());
    }

    private Acl toAcl(Permission permission) {
        Acl acl = new Acl();
        if (permission.getOther().implies(Permission.Action.read)) {
            acl.addAll(new Acl.GroupUser("AllUsers"), new Acl.Role("READ"));
        }
        if (permission.getGroup().implies(Permission.Action.read)) {
            acl.addAll(new Acl.GroupUser("AllAuthenticatedUsers"), new Acl.Role("READ"));
        }
        if (permission.getGroup().implies(Permission.Action.write)) {
            acl.addAll(new Acl.GroupUser("AllAuthenticatedUsers"), new Acl.Role("WRITE"));
        }
        return acl;
    }
}

