/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.random.SecureRandomProviderFactory;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;

public class CustomTrustSSLProtocolSocketFactory
extends SSLSocketFactory {
    private static final Logger log = Logger.getLogger(CustomTrustSSLProtocolSocketFactory.class);
    private final SSLSocketFactory factory;
    private final SSLContext context;
    private final String[] protocols;
    private final AtomicBoolean initializer = new AtomicBoolean(false);
    private final Preferences preferences = PreferencesFactory.get();
    private final X509TrustManager trust;
    private final X509KeyManager key;

    public CustomTrustSSLProtocolSocketFactory(X509TrustManager trust, X509KeyManager key) {
        this(trust, key, PreferencesFactory.get().getProperty("connection.ssl.protocols").split(","));
    }

    public CustomTrustSSLProtocolSocketFactory(X509TrustManager trust, X509KeyManager key, String ... protocols) {
        this(trust, key, SecureRandomProviderFactory.get().provide(), protocols);
    }

    public CustomTrustSSLProtocolSocketFactory(X509TrustManager trust, X509KeyManager key, SecureRandom seeder, String ... protocols) {
        this.trust = trust;
        this.key = key;
        try {
            this.context = SSLContext.getInstance("TLS");
            this.context.init(new KeyManager[]{key}, new TrustManager[]{trust}, seeder);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Using SSL context with protocol %s", this.context.getProtocol()));
            }
            this.factory = this.context.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new FactoryException(e.getMessage(), e);
        }
        this.protocols = protocols;
    }

    protected void configure(final Socket socket, String[] protocols) {
        if (socket instanceof SSLSocket) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Configure SSL parameters with protocols %s", Arrays.toString(protocols)));
                }
                ((SSLSocket)socket).setEnabledProtocols(protocols);
                List<String> ciphers = Arrays.asList(((SSLSocket)socket).getEnabledCipherSuites());
                List<String> blacklist = this.preferences.getList("connection.ssl.cipher.blacklist");
                if (!blacklist.isEmpty()) {
                    ciphers.removeIf(blacklist::contains);
                }
                ((SSLSocket)socket).setEnabledCipherSuites(ciphers.toArray(new String[ciphers.size()]));
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Enabled cipher suites %s", Arrays.toString(((SSLSocket)socket).getEnabledCipherSuites())));
                    ((SSLSocket)socket).addHandshakeCompletedListener(new HandshakeCompletedListener(){

                        @Override
                        public void handshakeCompleted(HandshakeCompletedEvent event) {
                            log.info((Object)String.format("Completed handshake with %s and negotiated cipher suite %s", event.getSession().getProtocol(), event.getCipherSuite()));
                            ((SSLSocket)socket).removeHandshakeCompletedListener(this);
                        }
                    });
                }
            }
            catch (Exception e) {
                log.warn((Object)String.format("Failed to configure SSL parameters %s", e.getMessage()));
            }
        }
    }

    protected Socket handshake(SocketGetter f) throws IOException {
        if (!this.initializer.get()) {
            this.trust.init();
            this.key.init();
            this.initializer.set(true);
        }
        Socket socket = f.create();
        this.configure(socket, this.protocols);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Handshake for socket %s", socket));
        }
        return socket;
    }

    public SSLContext getSSLContext() {
        return this.context;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.handshake(new SocketGetter(){

            @Override
            public Socket create() throws IOException {
                return CustomTrustSSLProtocolSocketFactory.this.factory.createSocket();
            }
        });
    }

    @Override
    public Socket createSocket(final String host, final int port, final InetAddress clientHost, final int clientPort) throws IOException {
        return this.handshake(new SocketGetter(){

            @Override
            public Socket create() throws IOException {
                return CustomTrustSSLProtocolSocketFactory.this.factory.createSocket(host, port, clientHost, clientPort);
            }
        });
    }

    @Override
    public Socket createSocket(final InetAddress host, final int port) throws IOException {
        return this.handshake(new SocketGetter(){

            @Override
            public Socket create() throws IOException {
                return CustomTrustSSLProtocolSocketFactory.this.factory.createSocket(host, port);
            }
        });
    }

    @Override
    public Socket createSocket(final InetAddress host, final int port, final InetAddress localHost, final int localPort) throws IOException {
        return this.handshake(new SocketGetter(){

            @Override
            public Socket create() throws IOException {
                return CustomTrustSSLProtocolSocketFactory.this.factory.createSocket(host, port, localHost, localPort);
            }
        });
    }

    @Override
    public Socket createSocket(final String host, final int port) throws IOException {
        return this.handshake(new SocketGetter(){

            @Override
            public Socket create() throws IOException {
                return CustomTrustSSLProtocolSocketFactory.this.factory.createSocket(host, port);
            }
        });
    }

    @Override
    public Socket createSocket(final Socket socket, final String host, final int port, final boolean autoClose) throws IOException {
        return this.handshake(new SocketGetter(){

            @Override
            public Socket create() throws IOException {
                return CustomTrustSSLProtocolSocketFactory.this.factory.createSocket(socket, host, port, autoClose);
            }
        });
    }

    private static interface SocketGetter {
        public Socket create() throws IOException;
    }
}

