/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.ssl.AbstractX509TrustManager;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class DefaultX509TrustManager
extends AbstractX509TrustManager {
    private static final Logger log = Logger.getLogger(DefaultX509TrustManager.class);
    private X509TrustManager system;

    @Override
    public DefaultX509TrustManager init() throws IOException {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(KeyStore.getInstance(KeyStore.getDefaultType()));
            TrustManager[] trustmanagers = factory.getTrustManagers();
            if (trustmanagers.length == 0) {
                throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
            }
            this.system = (X509TrustManager)trustmanagers[0];
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            log.error((Object)String.format("Initialization of trust store failed. %s", e.getMessage()));
            throw new IOException(e);
        }
        return this;
    }

    @Override
    public void verify(String hostname, X509Certificate[] certs, String cipher) throws CertificateException {
        certs[0].checkValidity();
        this.accept(Arrays.asList(certs));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String cipher) throws CertificateException {
        this.system.checkClientTrusted(certs, cipher);
        this.accept(Arrays.asList(certs));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String cipher) throws CertificateException {
        if (certs != null && log.isDebugEnabled()) {
            log.debug((Object)"Server certificate chain:");
            for (int i = 0; i < certs.length; ++i) {
                log.debug((Object)String.format("X509Certificate[%d]=%s", i, certs[i]));
            }
        }
        if (certs != null && certs.length == 1) {
            this.verify(null, certs, cipher);
        } else {
            this.system.checkServerTrusted(certs, cipher);
        }
    }
}

