/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.date.RemainingPeriodFormatter;
import ch.cyberduck.core.diagnostics.ReachabilityFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.BackgroundActionPauser;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public abstract class AbstractRetryCallable<T>
implements Callable<T> {
    private static final Logger log = Logger.getLogger(AbstractRetryCallable.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final Host host;
    private int retry;
    private int count = 0;
    private int backoff;

    public AbstractRetryCallable(Host host) {
        this(host, PreferencesFactory.get().getInteger("connection.retry"), PreferencesFactory.get().getInteger("connection.retry.delay"));
    }

    public AbstractRetryCallable(Host host, int retry, int delay) {
        this.host = host;
        this.retry = retry;
        this.backoff = delay;
    }

    @Override
    public abstract T call() throws BackgroundException;

    public boolean retry(BackgroundException failure, final ProgressListener progress, final BackgroundActionState cancel) {
        int delay;
        DefaultFailureDiagnostics diagnostics = new DefaultFailureDiagnostics();
        switch (diagnostics.determine(failure)) {
            case network: {
                if (!ReachabilityFactory.get().isReachable(this.host)) {
                    log.warn((Object)String.format("Cancel retry for failure %s with host %s not reachable", failure, this.host));
                    return false;
                }
                if (++this.count > this.retry) {
                    log.warn((Object)String.format("Cancel retry for failure %s", failure));
                    return false;
                }
                delay = this.backoff;
                break;
            }
            case application: {
                if (failure instanceof RetriableAccessDeniedException) {
                    Duration duration = ((RetriableAccessDeniedException)failure).getRetry();
                    if (duration != null) {
                        delay = (int)duration.getSeconds();
                        break;
                    }
                    if (++this.count > this.retry) {
                        log.warn((Object)String.format("Cancel retry for failure %s", failure));
                        return false;
                    }
                    delay = PreferencesFactory.get().getInteger("connection.retry.delay");
                    break;
                }
                log.warn((Object)String.format("No retry for failure %s", failure));
                return false;
            }
            default: {
                log.warn((Object)String.format("No retry for failure %s", failure));
                return false;
            }
        }
        log.warn((Object)String.format("Retry for failure %s with delay of %ds", failure, delay));
        if (delay > 0) {
            BackgroundActionPauser pause = new BackgroundActionPauser(new BackgroundActionPauser.Callback(){

                @Override
                public boolean isCanceled() {
                    return cancel.isCanceled();
                }

                @Override
                public void progress(Integer seconds) {
                    progress.message(MessageFormat.format(LocaleFactory.localizedString("Retry again in {0} ({1} more attempts)", "Status"), new RemainingPeriodFormatter().format(seconds.intValue()), AbstractRetryCallable.this.retry - AbstractRetryCallable.this.count));
                }
            }, delay);
            pause.await();
        }
        if (this.preferences.getBoolean("connection.retry.backoff.enable")) {
            this.backoff *= 2;
        }
        return !cancel.isCanceled();
    }

    public int getCount() {
        return this.count;
    }
}

