/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.download;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.download.AbstractDownloadFilter;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import org.apache.log4j.Logger;

public class SkipFilter
extends AbstractDownloadFilter {
    private static final Logger log = Logger.getLogger(SkipFilter.class);

    public SkipFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session) {
        super(symlinkResolver, session, new DownloadFilterOptions());
    }

    public SkipFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session, DownloadFilterOptions options) {
        super(symlinkResolver, session, options);
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        if (local.isFile() && local.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Skip file %s", file));
            }
            return false;
        }
        return super.accept(file, local, parent);
    }
}

