/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.lifecycle.LifecycleConfiguration;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryLifecycleFeature
implements Lifecycle {
    private final Session<?> session;
    private final Lifecycle proxy;
    private final VaultRegistry registry;

    public VaultRegistryLifecycleFeature(Session<?> session, Lifecycle proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public LifecycleConfiguration getConfiguration(Path container) throws BackgroundException {
        return this.registry.find(this.session, container).getFeature(this.session, Lifecycle.class, this.proxy).getConfiguration(container);
    }

    @Override
    public void setConfiguration(Path container, LifecycleConfiguration configuration) throws BackgroundException {
        this.registry.find(this.session, container).getFeature(this.session, Lifecycle.class, this.proxy).setConfiguration(container, configuration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryLifecycleFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

