/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.DefaultVaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import java.util.Collections;
import org.apache.log4j.Logger;

public class VaultRegistryMoveFeature
implements Move {
    private static final Logger log = Logger.getLogger(VaultRegistryMoveFeature.class);
    private final Session<?> session;
    private Session<?> destination;
    private final Move proxy;
    private final DefaultVaultRegistry registry;

    public VaultRegistryMoveFeature(Session<?> session, Move proxy, DefaultVaultRegistry registry) {
        this.session = session;
        this.destination = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public Path move(Path source, Path target, TransferStatus status, Delete.Callback delete, ConnectionCallback callback) throws BackgroundException {
        Vault vault = this.registry.find(this.session, source);
        if (vault.equals(this.registry.find(this.session, target, false))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Move %s to %s inside vault %s", source, target, vault));
            }
            return vault.getFeature(this.session, Move.class, this.proxy).move(source, target, status, delete, callback);
        }
        Path copy = this.session.getFeature(Copy.class).withTarget(this.destination).copy(source, target, status, callback);
        this.session.getFeature(Delete.class).delete(Collections.singletonList(source), callback, delete);
        return copy;
    }

    @Override
    public boolean isRecursive(Path source, Path target) {
        try {
            if (this.registry.find(this.session, source, false).equals(this.registry.find(this.session, target, false))) {
                return this.registry.find(this.session, source, false).getFeature(this.session, Move.class, this.proxy).isRecursive(source, target);
            }
            return this.session.getFeature(Copy.class).isRecursive(source, target);
        }
        catch (VaultUnlockCancelException e) {
            return this.proxy.isRecursive(source, target);
        }
    }

    @Override
    public boolean isSupported(Path source, Path target) {
        try {
            if (this.registry.find(this.session, source, false).equals(this.registry.find(this.session, target, false))) {
                return this.registry.find(this.session, source, false).getFeature(this.session, Move.class, this.proxy).isSupported(source, target);
            }
            return this.session.getFeature(Copy.class).isSupported(source, target);
        }
        catch (VaultUnlockCancelException e) {
            return this.proxy.isSupported(source, target);
        }
    }

    @Override
    public Move withDelete(Delete delete) {
        this.proxy.withDelete(delete);
        return this;
    }

    @Override
    public Move withTarget(Session<?> session) {
        this.destination = session.withRegistry(this.registry);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryMoveFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

