/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.worker.BooleanRecursiveCallback;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WorkerListProgressListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;

public class WriteMetadataWorker
extends Worker<Boolean> {
    private static final Logger log = Logger.getLogger(WriteMetadataWorker.class);
    private final List<Path> files;
    private final Map<String, String> metadata;
    private final Worker.RecursiveCallback<String> callback;
    private final ProgressListener listener;

    public WriteMetadataWorker(List<Path> files, Map<String, String> metadata, boolean recursive, ProgressListener listener) {
        this(files, metadata, new BooleanRecursiveCallback<String>(recursive), listener);
    }

    public WriteMetadataWorker(List<Path> files, Map<String, String> metadata, Worker.RecursiveCallback<String> callback, ProgressListener listener) {
        this.files = files;
        this.metadata = metadata;
        this.callback = callback;
        this.listener = listener;
    }

    @Override
    public Boolean run(Session<?> session) throws BackgroundException {
        Metadata feature = session.getFeature(Metadata.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Run with feature %s", feature));
        }
        for (Path file : this.files) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            this.write(session, feature, file);
        }
        return true;
    }

    protected void write(Session<?> session, Metadata feature, Path file) throws BackgroundException {
        if (this.isCanceled()) {
            throw new ConnectionCanceledException();
        }
        HashMap<String, String> update = new HashMap<String, String>(file.attributes().getMetadata());
        update.entrySet().removeIf(entry -> !this.metadata.containsKey(entry.getKey()));
        for (Map.Entry<String, String> entry2 : this.metadata.entrySet()) {
            if (entry2.getValue() == null) continue;
            update.put(entry2.getKey(), entry2.getValue());
        }
        if (!update.equals(file.attributes().getMetadata())) {
            this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Writing metadata of {0}", "Status"), file.getName()));
            feature.setMetadata(file, update);
            file.attributes().setMetadata(this.metadata);
        }
        if (file.isDirectory() && this.callback.recurse(file, LocaleFactory.localizedString("Metadata", "Info"))) {
            for (Path child : session.getFeature(ListService.class).list(file, new WorkerListProgressListener(this, this.listener))) {
                this.write(session, feature, child);
            }
        }
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Writing metadata of {0}", "Status"), this.toString(this.files));
    }

    @Override
    public Boolean initialize() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteMetadataWorker that = (WriteMetadataWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteMetadataWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

