/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.browser;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Objects;
import java.util.regex.Pattern;

public class RegexFilter
implements Filter<Path> {
    private final Pattern pattern = Pattern.compile(PreferencesFactory.get().getProperty("browser.hidden.regex"));

    @Override
    public boolean accept(Path file) {
        if (this.pattern.matcher(file.getName()).matches()) {
            return false;
        }
        if (file.getType().contains((Object)AbstractPath.Type.upload)) {
            return false;
        }
        return !file.attributes().isDuplicate();
    }

    @Override
    public Pattern toPattern() {
        return this.pattern;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RegexFilter{");
        sb.append("pattern=").append(this.pattern);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegexFilter)) {
            return false;
        }
        RegexFilter that = (RegexFilter)o;
        return Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }
}

