/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jdk8;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jdk8.BaseScalarOptionarDeserializer;
import java.io.IOException;
import java.util.OptionalInt;

public class OptionalIntDeserializer
extends BaseScalarOptionarDeserializer<OptionalInt> {
    private static final long serialVersionUID = 1L;
    static final OptionalIntDeserializer INSTANCE = new OptionalIntDeserializer();

    public OptionalIntDeserializer() {
        super(OptionalInt.class, OptionalInt.empty());
    }

    public OptionalInt deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return OptionalInt.of(p.getIntValue());
        }
        switch (p.getCurrentTokenId()) {
            case 6: {
                String text = p.getText().trim();
                if (text.length() == 0) {
                    this._coerceEmptyString(ctxt, false);
                    return (OptionalInt)this._empty;
                }
                if (this._hasTextualNull(text)) {
                    this._coerceTextualNull(ctxt, false);
                    return (OptionalInt)this._empty;
                }
                return OptionalInt.of(this._parseIntPrimitive(ctxt, text));
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p, ctxt, "int");
                }
                return OptionalInt.of(p.getValueAsInt());
            }
            case 11: {
                return (OptionalInt)this._empty;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                OptionalInt parsed = this.deserialize(p, ctxt);
                this._verifyEndArrayForSingle(p, ctxt);
                return parsed;
            }
        }
        return (OptionalInt)ctxt.handleUnexpectedToken(this._valueClass, p);
    }
}

