/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.exception;

import org.json.JSONException;
import org.json.JSONObject;

public class B2ApiException
extends Exception {
    private static final long serialVersionUID = -7345341271403812967L;
    private String code;
    private String message;
    private int status;
    private Integer retry;
    private final String json;

    public B2ApiException(String json, Throwable cause) {
        super(json, cause);
        this.json = json;
        this.parse(json);
    }

    private void parse(String json) {
        if (null != json) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                this.message = jsonObject.optString("message", null);
                this.status = jsonObject.optInt("status", -1);
                this.code = jsonObject.optString("code", null);
            }
            catch (JSONException ex) {
                this.message = json;
            }
        }
    }

    public B2ApiException withRetry(Integer retry) {
        this.retry = retry;
        return this;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getJson() {
        return this.json;
    }

    public int getStatus() {
        return this.status;
    }

    public Integer getRetry() {
        return this.retry;
    }
}

