/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.response;

import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import synapticloop.b2.Action;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.BaseB2Response;

public class B2FileInfoResponse
extends BaseB2Response {
    private static final Logger LOGGER = LoggerFactory.getLogger(B2FileInfoResponse.class);
    private final String fileId = this.readString("fileId");
    private final String fileName = this.readString("fileName");
    private final String contentType;
    private final String contentSha1;
    private final Long contentLength = this.readLong("contentLength");
    private final String accountId;
    private final String bucketId;
    private final Map<String, String> fileInfo;
    private Action action;
    private final Long size;
    private final Long uploadTimestamp;

    public B2FileInfoResponse(JSONObject response) throws B2ApiException {
        super(response);
        this.contentType = this.readString("contentType");
        this.contentSha1 = this.readString("contentSha1");
        this.fileInfo = this.readMap("fileInfo");
        String action = this.readString("action");
        if (null != action) {
            try {
                this.action = Action.valueOf(action);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Unknown action value " + action);
            }
        }
        this.size = this.readLong("size");
        this.uploadTimestamp = this.readLong("uploadTimestamp");
        this.accountId = this.readString("accountId");
        this.bucketId = this.readString("bucketId");
        this.warnOnMissedKeys();
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentSha1() {
        return this.contentSha1;
    }

    public Map<String, String> getFileInfo() {
        return this.fileInfo;
    }

    public Action getAction() {
        return this.action;
    }

    public long getSize() {
        return this.size;
    }

    public Long getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public String toString() {
        return "B2FileInfoResponse [fileId=" + this.fileId + ", fileName=" + this.fileName + ", contentType=" + this.contentType + ", contentSha1=" + this.contentSha1 + ", contentLength=" + this.contentLength + ", accountId=" + this.accountId + ", bucketId=" + this.bucketId + ", fileInfo=" + this.fileInfo + ", action=" + (Object)((Object)this.action) + ", size=" + this.size + ", uploadTimestamp=" + this.uploadTimestamp + "]";
    }
}

