/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoPathCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Vault;

public class CryptoIdProvider
implements IdProvider {
    private final Session<?> session;
    private final IdProvider delegate;
    private final Vault vault;

    public CryptoIdProvider(Session<?> session, IdProvider delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public String getFileid(Path file, ListProgressListener listener) throws BackgroundException {
        return this.delegate.getFileid(this.vault.encrypt(this.session, file), listener);
    }

    public IdProvider withCache(Cache<Path> cache) {
        this.delegate.withCache((Cache)new CryptoPathCache(cache));
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoIdProvider{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

