/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.logging.LoggingConfiguration;

public class CryptoLoggingFeature
implements Logging {
    private final Session<?> session;
    private final Logging delegate;
    private final Vault vault;

    public CryptoLoggingFeature(Session<?> session, Logging delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public LoggingConfiguration getConfiguration(Path container) throws BackgroundException {
        return this.delegate.getConfiguration(this.vault.encrypt(this.session, container));
    }

    public void setConfiguration(Path container, LoggingConfiguration configuration) throws BackgroundException {
        this.delegate.setConfiguration(this.vault.encrypt(this.session, container), configuration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoLoggingFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

