/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.random;

import ch.cyberduck.core.cryptomator.random.FastSecureRandomProvider;
import ch.cyberduck.core.random.NonceGenerator;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;

public final class RotatingNonceGenerator
implements NonceGenerator {
    private static final int len = 16;
    private final List<byte[]> nonces;
    private final SecureRandom random = FastSecureRandomProvider.get().provide();
    private final int capacity;
    private int index = 0;

    public RotatingNonceGenerator(int capacity) {
        this.capacity = capacity;
        this.nonces = new ArrayList<byte[]>(capacity);
    }

    public byte[] next() {
        if (this.index >= this.capacity) {
            this.index = 0;
        }
        if (this.nonces.size() <= this.index) {
            byte[] nonce = new byte[16];
            this.random.nextBytes(nonce);
            this.nonces.add(nonce);
        }
        return this.nonces.get(this.index++);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RotatingNonceGenerator{");
        sb.append("capacity=").append(this.capacity);
        sb.append(", index=").append(this.index);
        sb.append('}');
        return sb.toString();
    }
}

