/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftObjectListService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.log4j.Logger;

public class SwiftWriteFeature
extends AbstractHttpWriteFeature<StorageObject>
implements Write<StorageObject> {
    private static final Logger log = Logger.getLogger(SwiftSession.class);
    private final PathContainerService containerService = new PathContainerService();
    private final Preferences preferences = PreferencesFactory.get();
    private final SwiftSession session;
    private final SwiftSegmentService segmentService;
    private final SwiftObjectListService listService;
    private final Find finder;
    private final AttributesFinder attributes;
    private final SwiftRegionService regionService;

    public SwiftWriteFeature(SwiftSession session, SwiftRegionService regionService) {
        this(session, regionService, new SwiftObjectListService(session, regionService), new SwiftSegmentService(session, regionService), (Find)new DefaultFindFeature((Session)session));
    }

    public SwiftWriteFeature(SwiftSession session, SwiftRegionService regionService, SwiftObjectListService listService, SwiftSegmentService segmentService) {
        this(session, regionService, listService, segmentService, (Find)new DefaultFindFeature((Session)session));
    }

    public SwiftWriteFeature(SwiftSession session, SwiftRegionService regionService, SwiftObjectListService listService, SwiftSegmentService segmentService, Find finder) {
        this(session, regionService, listService, segmentService, finder, (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public SwiftWriteFeature(SwiftSession session, SwiftRegionService regionService, SwiftObjectListService listService, SwiftSegmentService segmentService, Find finder, AttributesFinder attributes) {
        super(finder, attributes);
        this.session = session;
        this.listService = listService;
        this.segmentService = segmentService;
        this.regionService = regionService;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<StorageObject> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<StorageObject> command = new DelayedHttpEntityCallable<StorageObject>(){

            public StorageObject call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    HashMap headers = new HashMap(status.getMetadata());
                    String checksum = ((Client)SwiftWriteFeature.this.session.getClient()).storeObject(SwiftWriteFeature.this.regionService.lookup(file), SwiftWriteFeature.this.containerService.getContainer(file).getName(), SwiftWriteFeature.this.containerService.getKey(file), (HttpEntity)entity, headers, Checksum.NONE == status.getChecksum() ? null : status.getChecksum().hash);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Saved object %s with checksum %s", file, checksum));
                    }
                    StorageObject stored = new StorageObject(SwiftWriteFeature.this.containerService.getKey(file));
                    stored.setMd5sum(checksum);
                    stored.setSize(Long.valueOf(status.getLength()));
                    return stored;
                }
                catch (GenericException e) {
                    throw new SwiftExceptionMappingService().map("Upload {0} failed", e, file);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (length >= this.preferences.getLong("openstack.upload.largeobject.threshold") && this.preferences.getBoolean("openstack.upload.largeobject")) {
            List segments;
            long size = 0L;
            try {
                segments = this.listService.list(this.segmentService.getSegmentsDirectory(file, length), (ListProgressListener)new DisabledListProgressListener()).toList();
                if (segments.isEmpty()) {
                    return Write.notfound;
                }
            }
            catch (NotfoundException e) {
                return Write.notfound;
            }
            for (Path segment : segments) {
                size += segment.attributes().getSize();
            }
            return new Write.Append(Long.valueOf(size));
        }
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public ChecksumCompute checksum(Path file) {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5);
    }
}

