/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.logging.LoggingConfiguration;
import com.microsoft.azure.storage.LoggingOperations;
import com.microsoft.azure.storage.LoggingProperties;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.ServiceProperties;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import java.util.Collections;
import java.util.EnumSet;

public class AzureLoggingFeature
implements Logging {
    private final AzureSession session;
    private final OperationContext context;

    public AzureLoggingFeature(AzureSession session, OperationContext context) {
        this.session = session;
        this.context = context;
    }

    public LoggingConfiguration getConfiguration(Path container) throws BackgroundException {
        try {
            ServiceProperties properties = ((CloudBlobClient)this.session.getClient()).downloadServiceProperties(null, this.context);
            LoggingConfiguration configuration = new LoggingConfiguration(!properties.getLogging().getLogOperationTypes().isEmpty(), "$logs");
            configuration.setContainers(Collections.singletonList(new Path("/$logs", EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory))));
            return configuration;
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Cannot read container configuration", e);
        }
    }

    public void setConfiguration(Path container, LoggingConfiguration configuration) throws BackgroundException {
        try {
            ServiceProperties properties = ((CloudBlobClient)this.session.getClient()).downloadServiceProperties(null, this.context);
            LoggingProperties l = new LoggingProperties();
            if (configuration.isEnabled()) {
                l.setLogOperationTypes(EnumSet.allOf(LoggingOperations.class));
            } else {
                l.setLogOperationTypes(EnumSet.noneOf(LoggingOperations.class));
            }
            properties.setLogging(l);
            ((CloudBlobClient)this.session.getClient()).uploadServiceProperties(properties, null, this.context);
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Failure to write attributes of {0}", e, container);
        }
    }
}

