/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.azure.AzurePathContainerService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.SharedAccessBlobPermissions;
import com.microsoft.azure.storage.blob.SharedAccessBlobPolicy;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.TimeZone;

public class AzureUrlProvider
implements UrlProvider {
    private final PathContainerService containerService = new AzurePathContainerService();
    private final AzureSession session;

    public AzureUrlProvider(AzureSession session) {
        this.session = session;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        list.addAll((Collection)new DefaultUrlProvider(this.session.getHost()).toUrl(file));
        if (file.isFile()) {
            list.add(this.createSignedUrl(file, 3600));
            list.add(this.createSignedUrl(file, PreferencesFactory.get().getInteger("s3.url.expire.seconds")));
            list.add(this.createSignedUrl(file, 604800));
            list.add(this.createSignedUrl(file, 2419200));
        }
        return list;
    }

    private DescriptiveUrl createSignedUrl(Path file, int seconds) {
        String token;
        CloudBlob blob;
        try {
            if (!this.session.isConnected()) {
                return DescriptiveUrl.EMPTY;
            }
            blob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getBlobReferenceFromServer(this.containerService.getKey(file));
        }
        catch (StorageException | URISyntaxException e) {
            return DescriptiveUrl.EMPTY;
        }
        try {
            token = blob.generateSharedAccessSignature(this.getPolicy(seconds), null);
        }
        catch (StorageException | InvalidKeyException e) {
            return DescriptiveUrl.EMPTY;
        }
        return new DescriptiveUrl(URI.create(String.format("%s://%s%s?%s", Scheme.https.name(), this.session.getHost().getHostname(), URIEncoder.encode((String)file.getAbsolute()), token)), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getShortFormat(this.getExpiry(seconds).longValue())));
    }

    private SharedAccessBlobPolicy getPolicy(int expiry) {
        SharedAccessBlobPolicy policy = new SharedAccessBlobPolicy();
        policy.setSharedAccessExpiryTime(new Date(this.getExpiry(expiry)));
        policy.setPermissions(EnumSet.of(SharedAccessBlobPermissions.READ));
        return policy;
    }

    protected Long getExpiry(int seconds) {
        Calendar expiry = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        expiry.add(13, seconds);
        return expiry.getTimeInMillis();
    }
}

