/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib;

import dagger.internal.Preconditions;
import java.security.SecureRandom;
import org.cryptomator.cryptolib.CryptoLibComponent;
import org.cryptomator.cryptolib.CryptoLibModule;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.common.SecureRandomModule;
import org.cryptomator.cryptolib.common.SecureRandomModule_ProvideFastSecureRandomFactory;
import org.cryptomator.cryptolib.common.SecureRandomModule_ProvideNativeSecureRandomFactory;
import org.cryptomator.cryptolib.v1.Version1CryptorModule;
import org.cryptomator.cryptolib.v1.Version1CryptorModule_ProvideCryptorProviderFactory;

public final class DaggerCryptoLibComponent
implements CryptoLibComponent {
    private Version1CryptorModule version1CryptorModule;
    private SecureRandomModule secureRandomModule;

    private DaggerCryptoLibComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private SecureRandom getFastSecureRandomSecureRandom() {
        return SecureRandomModule_ProvideFastSecureRandomFactory.proxyProvideFastSecureRandom(this.secureRandomModule, SecureRandomModule_ProvideNativeSecureRandomFactory.proxyProvideNativeSecureRandom(this.secureRandomModule));
    }

    private void initialize(Builder builder) {
        this.version1CryptorModule = builder.version1CryptorModule;
        this.secureRandomModule = builder.secureRandomModule;
    }

    @Override
    public CryptorProvider version1() {
        return Version1CryptorModule_ProvideCryptorProviderFactory.proxyProvideCryptorProvider(this.version1CryptorModule, this.getFastSecureRandomSecureRandom());
    }

    public static final class Builder {
        private SecureRandomModule secureRandomModule;
        private Version1CryptorModule version1CryptorModule;

        private Builder() {
        }

        public CryptoLibComponent build() {
            if (this.secureRandomModule == null) {
                throw new IllegalStateException(SecureRandomModule.class.getCanonicalName() + " must be set");
            }
            if (this.version1CryptorModule == null) {
                this.version1CryptorModule = new Version1CryptorModule();
            }
            return new DaggerCryptoLibComponent(this);
        }

        @Deprecated
        public Builder cryptoLibModule(CryptoLibModule cryptoLibModule) {
            Preconditions.checkNotNull((Object)cryptoLibModule);
            return this;
        }

        public Builder version1CryptorModule(Version1CryptorModule version1CryptorModule) {
            this.version1CryptorModule = (Version1CryptorModule)Preconditions.checkNotNull((Object)version1CryptorModule);
            return this;
        }

        public Builder secureRandomModule(SecureRandomModule secureRandomModule) {
            this.secureRandomModule = (SecureRandomModule)Preconditions.checkNotNull((Object)secureRandomModule);
            return this;
        }
    }
}

