/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public final class CipherSupplier {
    public static final CipherSupplier AES_CTR = new CipherSupplier("AES/CTR/NoPadding");
    public static final CipherSupplier RFC3394_KEYWRAP = new CipherSupplier("AESWrap");
    private final String cipherAlgorithm;
    private final ThreadLocal<Cipher> threadLocal;

    public CipherSupplier(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
        this.threadLocal = new Provider();
        this.threadLocal.get();
    }

    public Cipher forEncryption(SecretKey key, AlgorithmParameterSpec params) {
        return this.forMode(1, key, params);
    }

    public Cipher forDecryption(SecretKey key, AlgorithmParameterSpec params) {
        return this.forMode(2, key, params);
    }

    public Cipher forWrapping(SecretKey kek) {
        return this.forMode(3, kek, null);
    }

    public Cipher forUnwrapping(SecretKey kek) {
        return this.forMode(4, kek, null);
    }

    Cipher forMode(int ciphermode, SecretKey key, AlgorithmParameterSpec params) {
        Cipher cipher = this.threadLocal.get();
        try {
            cipher.init(ciphermode, (Key)key, params);
            return cipher;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException("Algorithm parameter not appropriate for " + cipher.getAlgorithm() + ".", e);
        }
    }

    private class Provider
    extends ThreadLocal<Cipher> {
        private Provider() {
        }

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(CipherSupplier.this.cipherAlgorithm);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new IllegalArgumentException("Invalid cipher algorithm or padding.", e);
            }
        }
    }
}

