/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.KeyFile;
import org.cryptomator.cryptolib.api.UnsupportedVaultFormatException;
import org.cryptomator.cryptolib.common.AesKeyWrap;
import org.cryptomator.cryptolib.common.MacSupplier;
import org.cryptomator.cryptolib.common.Scrypt;
import org.cryptomator.cryptolib.v1.CryptorImpl;
import org.cryptomator.cryptolib.v1.KeyFileImpl;

class CryptorProviderImpl
implements CryptorProvider {
    private final SecureRandom random;
    private final KeyGenerator encKeyGen;
    private final KeyGenerator macKeyGen;

    public CryptorProviderImpl(SecureRandom random) {
        this.random = random;
        try {
            this.encKeyGen = KeyGenerator.getInstance("AES");
            this.encKeyGen.init(256, random);
            this.macKeyGen = KeyGenerator.getInstance("HmacSHA256");
            this.macKeyGen.init(256, random);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Hard-coded algorithm doesn't exist.", e);
        }
    }

    @Override
    public CryptorImpl createNew() {
        SecretKey encKey = this.encKeyGen.generateKey();
        SecretKey macKey = this.macKeyGen.generateKey();
        return new CryptorImpl(encKey, macKey, this.random);
    }

    @Override
    public CryptorImpl createFromKeyFile(KeyFile keyFile, CharSequence passphrase, int expectedVaultVersion) throws UnsupportedVaultFormatException, InvalidPassphraseException {
        return this.createFromKeyFile(keyFile, passphrase, new byte[0], expectedVaultVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CryptorImpl createFromKeyFile(KeyFile keyFile, CharSequence passphrase, byte[] pepper, int expectedVaultVersion) throws UnsupportedVaultFormatException, InvalidPassphraseException {
        KeyFileImpl keyFileImpl = keyFile.as(KeyFileImpl.class);
        byte[] salt = keyFileImpl.scryptSalt;
        byte[] saltAndPepper = new byte[salt.length + pepper.length];
        System.arraycopy(salt, 0, saltAndPepper, 0, salt.length);
        System.arraycopy(pepper, 0, saltAndPepper, salt.length, pepper.length);
        byte[] kekBytes = Scrypt.scrypt(passphrase, saltAndPepper, keyFileImpl.scryptCostParam, keyFileImpl.scryptBlockSize, 32);
        try {
            SecretKeySpec kek = new SecretKeySpec(kekBytes, "AES");
            CryptorImpl cryptorImpl = this.createFromKeyFile(keyFileImpl, kek, expectedVaultVersion);
            return cryptorImpl;
        }
        finally {
            Arrays.fill(kekBytes, (byte)0);
        }
    }

    private CryptorImpl createFromKeyFile(KeyFileImpl keyFile, SecretKey kek, int expectedVaultVersion) throws UnsupportedVaultFormatException, InvalidPassphraseException {
        if (expectedVaultVersion != keyFile.getVersion()) {
            throw new UnsupportedVaultFormatException(keyFile.getVersion(), expectedVaultVersion);
        }
        try {
            SecretKey macKey = AesKeyWrap.unwrap(kek, keyFile.macMasterKey, "HmacSHA256");
            Mac mac = MacSupplier.HMAC_SHA256.withKey(macKey);
            byte[] versionMac = mac.doFinal(ByteBuffer.allocate(4).putInt(expectedVaultVersion).array());
            if (keyFile.versionMac == null || !MessageDigest.isEqual(versionMac, keyFile.versionMac)) {
                throw new UnsupportedVaultFormatException(Integer.MAX_VALUE, expectedVaultVersion);
            }
            SecretKey encKey = AesKeyWrap.unwrap(kek, keyFile.encryptionMasterKey, "AES");
            return new CryptorImpl(encKey, macKey, this.random);
        }
        catch (InvalidKeyException e) {
            throw new InvalidPassphraseException();
        }
    }
}

