/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.impl.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteCountInputStream
extends FilterInputStream {
    private Long byteCount = 0L;

    public ByteCountInputStream(InputStream in) {
        super(in);
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = this.in.skip(n);
        this.byteCount = this.byteCount + skip;
        return skip;
    }

    @Override
    public int read() throws IOException {
        int data = this.in.read();
        this.byteCount = this.byteCount + (data == -1 ? 0L : 1L);
        return data;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.in.read(b);
        this.byteCount = this.byteCount + (read == -1 ? 0L : (long)read);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        this.byteCount = this.byteCount + (read == -1 ? 0L : (long)read);
        return read;
    }

    public Long getByteCount() {
        return this.byteCount;
    }
}

