/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.webloc.UrlFileWriter;
import ch.cyberduck.core.webloc.UrlFileWriterFactory;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDrivePackageItem;
import org.nuxeo.onedrive.client.OneDriveRemoteItem;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class GraphItemListService
implements ListService {
    private static final Logger log = Logger.getLogger(GraphItemListService.class);
    private final GraphSession session;
    private final GraphAttributesFinderFeature attributes;
    private final UrlFileWriter urlFileWriter = UrlFileWriterFactory.get();

    public GraphItemListService(GraphSession session) {
        this.session = session;
        this.attributes = new GraphAttributesFinderFeature(session);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList children = new AttributedList();
        OneDriveFolder folder = this.session.toFolder(directory);
        try {
            Iterator iterator = folder.iterator(PreferencesFactory.get().getInteger("onedrive.listing.chunksize"), new OneDriveExpand[0]);
            while (iterator.hasNext()) {
                OneDriveItem.Metadata metadata;
                try {
                    metadata = (OneDriveItem.Metadata)iterator.next();
                }
                catch (OneDriveRuntimeException e) {
                    log.warn((Object)e.getMessage());
                    continue;
                }
                PathAttributes attr = this.attributes.toAttributes(metadata);
                String fileName = metadata instanceof OneDrivePackageItem.Metadata ? String.format("%s.%s", PathNormalizer.name((String)metadata.getName()), this.urlFileWriter.getExtension()) : metadata.getName();
                children.add((Referenceable)new Path(directory, fileName, this.resolveType(metadata), attr));
                listener.chunk(directory, children);
            }
        }
        catch (OneDriveRuntimeException e) {
            throw new GraphExceptionMappingService().map("Listing directory {0} failed", e.getCause(), directory);
        }
        return children;
    }

    public ListService withCache(Cache<Path> cache) {
        this.attributes.withCache(cache);
        return this;
    }

    private EnumSet<AbstractPath.Type> resolveType(OneDriveItem.Metadata metadata) {
        if (metadata instanceof OneDrivePackageItem.Metadata) {
            return EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.placeholder);
        }
        if (metadata instanceof OneDriveRemoteItem.Metadata) {
            EnumSet<AbstractPath.Type> types = this.resolveType(((OneDriveRemoteItem.Metadata)metadata).getRemoteItem());
            types.add(AbstractPath.Type.shared);
            return types;
        }
        return EnumSet.of(metadata.isFolder() ? AbstractPath.Type.directory : AbstractPath.Type.file);
    }
}

