/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.onedrive.GraphDrivesListService;
import ch.cyberduck.core.onedrive.GraphItemListService;
import ch.cyberduck.core.onedrive.SharepointGroupDrivesListService;
import ch.cyberduck.core.onedrive.SharepointGroupListService;
import ch.cyberduck.core.onedrive.SharepointSession;
import java.util.EnumSet;

public class SharepointListService
implements ListService {
    private static final String DEFAULT_ID = "DEFAULT_NAME";
    private static final String GROUPS_ID = "GROUPS_NAME";
    public static final Path DEFAULT_NAME = new Path("/Default", EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.placeholder, AbstractPath.Type.directory), new PathAttributes().withVersionId("DEFAULT_NAME"));
    public static final Path GROUPS_NAME = new Path("/Groups", EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.placeholder, AbstractPath.Type.directory), new PathAttributes().withVersionId("GROUPS_NAME"));
    private final SharepointSession session;
    private final IdProvider idProvider;

    public SharepointListService(SharepointSession session, IdProvider idProvider) {
        this.session = session;
        this.idProvider = idProvider;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            AttributedList list = new AttributedList();
            list.add((Referenceable)DEFAULT_NAME);
            list.add((Referenceable)GROUPS_NAME);
            listener.chunk(directory, list);
            return list;
        }
        if (DEFAULT_NAME.equals((Object)directory)) {
            return new GraphDrivesListService(this.session).list(directory, listener);
        }
        if (GROUPS_NAME.equals((Object)directory)) {
            return new SharepointGroupListService(this.session).list(directory, listener);
        }
        if (GROUPS_NAME.equals((Object)directory.getParent())) {
            return new SharepointGroupDrivesListService(this.session, this.idProvider).list(directory, listener);
        }
        return new GraphItemListService(this.session).list(directory, listener);
    }

    public ListService withCache(Cache<Path> cache) {
        this.idProvider.withCache(cache);
        return this;
    }
}

