/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.IOException;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.AuthMechanism;
import org.irods.jargon.core.connection.ClientServerNegotiationPolicy;
import org.irods.jargon.core.connection.NegotiatedClientServerConfiguration;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.connection.SslConnectionUtilities;
import org.irods.jargon.core.connection.StartupResponseData;
import org.irods.jargon.core.exception.ClientServerNegotiationException;
import org.irods.jargon.core.exception.EncryptionException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.ClientServerNegotiationStructInitNegotiation;
import org.irods.jargon.core.packinstr.ClientServerNegotiationStructNotifyServerOfResult;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.protovalues.EncryptionAlgorithmEnum;
import org.irods.jargon.core.transfer.encrypt.AESKeyGenerator;
import org.irods.jargon.core.transfer.encrypt.AbstractKeyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientServerNegotiationService {
    private final AbstractIRODSMidLevelProtocol irodsMidLevelProtocol;
    private Logger log = LoggerFactory.getLogger(ClientServerNegotiationService.class);
    public static final String NEGOTIATION_SHARED_SECRET = "SHARED_SECRET";
    private ClientServerNegotiationStructNotifyServerOfResult.Outcome[][] negotiationTable = new ClientServerNegotiationStructNotifyServerOfResult.Outcome[3][3];

    ClientServerNegotiationService(AbstractIRODSMidLevelProtocol irodsMidLevelProtocol) {
        this.irodsMidLevelProtocol = irodsMidLevelProtocol;
        this.initializeNegotiationTable();
    }

    private void initializeNegotiationTable() {
        this.negotiationTable[0][0] = ClientServerNegotiationStructNotifyServerOfResult.Outcome.CS_NEG_USE_SSL;
        this.negotiationTable[0][1] = ClientServerNegotiationStructNotifyServerOfResult.Outcome.CS_NEG_USE_SSL;
        this.negotiationTable[0][2] = ClientServerNegotiationStructNotifyServerOfResult.Outcome.CS_NEG_USE_TCP;
        this.negotiationTable[1][0] = ClientServerNegotiationStructNotifyServerOfResult.Outcome.CS_NEG_USE_SSL;
        this.negotiationTable[1][1] = ClientServerNegotiationStructNotifyServerOfResult.Outcome.CS_NEG_USE_SSL;
        this.negotiationTable[1][2] = ClientServerNegotiationStructNotifyServerOfResult.Outcome.CS_NEG_USE_TCP;
        this.negotiationTable[2][0] = ClientServerNegotiationStructNotifyServerOfResult.Outcome.CS_NEG_FAILURE;
        this.negotiationTable[2][1] = ClientServerNegotiationStructNotifyServerOfResult.Outcome.CS_NEG_USE_TCP;
        this.negotiationTable[2][2] = ClientServerNegotiationStructNotifyServerOfResult.Outcome.CS_NEG_USE_TCP;
    }

    AbstractIRODSMidLevelProtocol getIrodsMidLevelProtocol() {
        return this.irodsMidLevelProtocol;
    }

    private ClientServerNegotiationPolicy referToNegotiationPolicy() {
        return this.getIrodsMidLevelProtocol().getIrodsConnection().getOperativeClientServerNegotiationPolicy();
    }

    StartupResponseData negotiate(ClientServerNegotiationStructInitNegotiation struct) throws ClientServerNegotiationException, JargonException {
        this.log.info("negotiate()");
        if (struct == null) {
            throw new IllegalArgumentException("null struct");
        }
        return this.negotiateUsingServerProtocol(struct);
    }

    private StartupResponseData negotiateUsingServerProtocol(ClientServerNegotiationStructInitNegotiation struct) throws ClientServerNegotiationException, JargonException {
        this.log.info("negotiateUsingServerProtocol()");
        this.log.info("negotiation over response from server:{}", (Object)struct);
        this.log.info("client policy:{}", (Object)this.referToNegotiationPolicy());
        ClientServerNegotiationStructNotifyServerOfResult.Outcome negotiatedOutcome = this.negotiationTable[this.referToNegotiationPolicy().getSslNegotiationPolicy().ordinal()][struct.getSslNegotiationPolicy().ordinal()];
        this.log.info("negotiatedOutcome:{}", (Object)negotiatedOutcome);
        if (negotiatedOutcome == ClientServerNegotiationStructNotifyServerOfResult.Outcome.CS_NEG_FAILURE) {
            this.log.error("failure in client server negotiation!...sending error message to the server before throwing the failure exception");
            this.notifyServerOfNegotiationFailure();
            throw new ClientServerNegotiationException("failure in client server negotiation");
        }
        this.log.info("was a success, return choice to server");
        StartupResponseData startupResponseData = this.notifyServerOfNegotiationSuccess(negotiatedOutcome);
        this.irodsMidLevelProtocol.setStartupResponseData(startupResponseData);
        return startupResponseData;
    }

    private StartupResponseData notifyServerOfNegotiationSuccess(ClientServerNegotiationStructNotifyServerOfResult.Outcome negotiatedOutcome) throws JargonException {
        ClientServerNegotiationStructNotifyServerOfResult struct = ClientServerNegotiationStructNotifyServerOfResult.instance(1, negotiatedOutcome.name());
        Tag versionPiTag = this.irodsMidLevelProtocol.irodsFunctionForNegotiation(struct);
        StartupResponseData startupResponse = AuthMechanism.buldStartupResponseFromVersionPI(versionPiTag);
        startupResponse.setNegotiatedClientServerConfiguration(new NegotiatedClientServerConfiguration(negotiatedOutcome == ClientServerNegotiationStructNotifyServerOfResult.Outcome.CS_NEG_USE_SSL));
        this.log.info("startupResponse captured:{}", (Object)startupResponse);
        this.wrapConnectionInSslIfConfigured(startupResponse);
        return startupResponse;
    }

    private void wrapConnectionInSslIfConfigured(StartupResponseData startupResponse) throws JargonException, AssertionError {
        this.log.info("wrapConnectionInSsl()");
        if (startupResponse.getNegotiatedClientServerConfiguration() == null) {
            throw new IllegalArgumentException("null negotiatedClientServerConfiguration in startup response");
        }
        if (!startupResponse.getNegotiatedClientServerConfiguration().isSslConnection()) {
            this.log.info("no ssl");
            return;
        }
        this.log.info("wrapping in ssl connection");
        SslConnectionUtilities sslConnectionUtilities = new SslConnectionUtilities(this.getIrodsMidLevelProtocol().getIrodsSession());
        this.getIrodsMidLevelProtocol().setIrodsConnectionNonEncryptedRef(this.getIrodsMidLevelProtocol().getIrodsConnection());
        sslConnectionUtilities.createSslSocketForProtocolAndIntegrateIntoProtocol(this.getIrodsMidLevelProtocol().getIrodsAccount(), this.getIrodsMidLevelProtocol(), false);
        this.configureParametersForParallelTransfer(startupResponse);
        this.getIrodsMidLevelProtocol().setStartupResponseData(startupResponse);
        this.log.info("connection now wrapped in ssl socket!");
    }

    private void configureParametersForParallelTransfer(StartupResponseData startupResponse) throws JargonException {
        this.log.info("configureParametersForParallelTransfer()");
        PipelineConfiguration myProps = PipelineConfiguration.instance(this.getIrodsMidLevelProtocol().getIrodsSession().getJargonProperties());
        this.log.info("setting up secret key");
        this.log.info("creating secret key for parallel transfer encryption using:{}", (Object)myProps.getEncryptionAlgorithmEnum());
        if (myProps.getEncryptionAlgorithmEnum() != EncryptionAlgorithmEnum.AES_256_CBC) {
            this.log.error("unable to generate a key for algo:{}", (Object)myProps.getEncryptionAlgorithmEnum());
            throw new EncryptionException("unable to generate a key");
        }
        this.log.info("AES key selected");
        AESKeyGenerator generator = new AESKeyGenerator(myProps, startupResponse.getNegotiatedClientServerConfiguration());
        startupResponse.getNegotiatedClientServerConfiguration().setSecretKey(((AbstractKeyGenerator)generator).generateKey());
        try {
            this.log.info("sending header with encryption cues");
            this.getIrodsMidLevelProtocol().sendHeader(myProps.getEncryptionAlgorithmEnum().getTextValue(), myProps.getEncryptionKeySize(), myProps.getEncryptionSaltSize(), myProps.getEncryptionNumberHashRounds(), 0);
            this.getIrodsMidLevelProtocol().getIrodsConnection().flush();
            this.log.info("now write the shared secret to iRODS");
            this.getIrodsMidLevelProtocol().irodsFunctionUnidirectional(NEGOTIATION_SHARED_SECRET, startupResponse.getNegotiatedClientServerConfiguration().getSecretKey().getEncoded(), null, 0, 0, null, 0, 0, 0);
        }
        catch (IOException e) {
            this.log.error("i/o exception sending encryption info", (Throwable)e);
            throw new JargonException("error sending encryption info");
        }
    }

    private void notifyServerOfNegotiationFailure() throws JargonException {
        ClientServerNegotiationStructNotifyServerOfResult struct = ClientServerNegotiationStructNotifyServerOfResult.instanceForFailure();
        this.irodsMidLevelProtocol.irodsFunction(struct);
    }
}

