/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;

public class FileReadInp
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "fileReadInp_PI";
    public static final int FILE_READ_API_NBR = 691;
    public static final String FILE_INX = "fileInx";
    public static final String LEN = "len";
    private final int fileDescriptor;
    private final long length;

    public static final FileReadInp instanceForReadStream(int fileDescriptor, long length) throws JargonException {
        return new FileReadInp(691, fileDescriptor, length);
    }

    private FileReadInp(int apiNumber, int fileDescriptor, long length) {
        if (fileDescriptor <= 0) {
            throw new IllegalArgumentException("fileDescriptor is less than or equal to zero");
        }
        if (length <= 0L) {
            throw new IllegalArgumentException("length is less than or equal to zero");
        }
        this.fileDescriptor = fileDescriptor;
        this.length = length;
        this.setApiNumber(apiNumber);
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag(PI_TAG, new Tag[]{new Tag(FILE_INX, this.fileDescriptor), new Tag(LEN, this.length)});
        return message;
    }
}

