/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.InvalidResourceException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.ResourceHierarchyException;
import org.irods.jargon.core.packinstr.GeneralAdminInpForResources;
import org.irods.jargon.core.packinstr.ModAvuMetadataInp;
import org.irods.jargon.core.protovalues.ErrorEnum;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.ResourceAO;
import org.irods.jargon.core.pub.ResourceAOHelper;
import org.irods.jargon.core.pub.ResourceGroupAO;
import org.irods.jargon.core.pub.domain.AvuData;
import org.irods.jargon.core.pub.domain.Resource;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.query.AVUQueryElement;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.GenQueryOrderByField;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSGenQueryFromBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.MetaDataAndDomainData;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.AccessObjectQueryProcessingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceAOImpl
extends IRODSGenericAO
implements ResourceAO {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String ERROR_IN_RESOURCE_QUERY = "error in resource query";
    private final transient ResourceAOHelper resourceAOHelper;

    protected ResourceAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
        this.getIRODSAccessObjectFactory().getZoneAO(this.getIRODSAccount());
        this.resourceAOHelper = new ResourceAOHelper(this.getIRODSAccount(), this.getIRODSAccessObjectFactory());
    }

    @Override
    public void addResource(Resource resource) throws DuplicateDataException, JargonException {
        this.log.info("addResource()");
        if (resource == null) {
            throw new IllegalArgumentException("null resource");
        }
        this.log.info("resource:{}", (Object)resource);
        if (!this.getIRODSServerProperties().isAtLeastIrods410()) {
            this.log.error("does not work pre iRODS 4.1");
            throw new UnsupportedOperationException("add resource only works for 4.1+");
        }
        GeneralAdminInpForResources adminPI = GeneralAdminInpForResources.instanceForAddResource(resource);
        this.log.debug("executing admin PI");
        this.getIRODSProtocol().irodsFunction(adminPI);
        this.getIRODSAccessObjectFactory().closeSession(this.getIRODSAccount());
        this.log.info("complete");
    }

    @Override
    public void modifyResource(Resource resource, String what) throws JargonException {
        this.log.info("modifyResource()");
        if (resource == null) {
            throw new IllegalArgumentException("null resource");
        }
        this.log.info("resource:{}", (Object)resource);
        if (!this.getIRODSServerProperties().isAtLeastIrods410()) {
            this.log.error("does not work pre iRODS 4.1");
            throw new UnsupportedOperationException("add resource only works for 4.1+");
        }
        GeneralAdminInpForResources adminPI = GeneralAdminInpForResources.instanceForModifyResource(resource, what);
        this.log.debug("executing admin PI");
        this.getIRODSProtocol().irodsFunction(adminPI);
        this.getIRODSAccessObjectFactory().closeSession(this.getIRODSAccount());
        this.log.info("complete");
    }

    @Override
    public void deleteResource(String resourceName) throws Exception {
        this.log.info("deleteResource()");
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourceName");
        }
        GeneralAdminInpForResources adminPI = GeneralAdminInpForResources.instanceForRemoveResource(resourceName);
        this.log.debug("executing admin PI");
        try {
            this.getIRODSProtocol().irodsFunction(adminPI);
        }
        catch (DataNotFoundException e) {
            this.log.warn("data not found deleting resource, silently ignore", (Throwable)e);
        }
        this.getIRODSAccessObjectFactory().closeSession(this.getIRODSAccount());
        this.log.info("complete");
    }

    @Override
    public void addChildToResource(String parent, String child, String optionalContext) throws JargonException {
        this.log.info("addChildToResource");
        if (!this.getIRODSServerProperties().isAtLeastIrods410()) {
            this.log.error("does not work pre iRODS 4.1");
            throw new UnsupportedOperationException("only works for iRODS 4.1+");
        }
        if (child == null || child.isEmpty()) {
            throw new IllegalArgumentException("null or empty child");
        }
        if (parent == null || parent.isEmpty()) {
            throw new IllegalArgumentException("null or empty parent");
        }
        if (optionalContext == null) {
            throw new IllegalArgumentException("null  optionalContext");
        }
        GeneralAdminInpForResources adminPI = GeneralAdminInpForResources.instanceForAddChildToResource(child, parent, optionalContext);
        this.log.debug("executing admin PI");
        try {
            this.getIRODSProtocol().irodsFunction(adminPI);
        }
        catch (ResourceHierarchyException e) {
            if (e.getUnderlyingIRODSExceptionCode() == ErrorEnum.CHILD_HAS_PARENT.getInt()) {
                this.log.warn("duplicate child ignored", (Throwable)e);
            }
            this.log.error("unknown resource exception", (Throwable)e);
            throw e;
        }
        this.getIRODSAccessObjectFactory().closeSession(this.getIRODSAccount());
        this.log.info("complete");
    }

    @Override
    public void removeChildFromResource(String parent, String child) throws InvalidResourceException, JargonException {
        this.log.info("removeChildFromResource");
        if (!this.getIRODSServerProperties().isAtLeastIrods410()) {
            this.log.error("does not work pre iRODS 4.1");
            throw new UnsupportedOperationException("only works for iRODS 4.1+");
        }
        if (child == null || child.isEmpty()) {
            throw new IllegalArgumentException("null or empty child");
        }
        if (parent == null || parent.isEmpty()) {
            throw new IllegalArgumentException("null or empty parent");
        }
        GeneralAdminInpForResources adminPI = GeneralAdminInpForResources.instanceForRemoveChildFromResource(child, parent);
        this.log.debug("executing admin PI");
        this.getIRODSProtocol().irodsFunction(adminPI);
        this.getIRODSAccessObjectFactory().closeSession(this.getIRODSAccount());
        this.log.info("complete");
    }

    @Override
    public Resource findByName(String resourceName) throws JargonException, DataNotFoundException {
        String message;
        StringBuilder messageBuilder;
        IRODSQueryResultSet resultSet;
        IRODSGenQueryBuilder builder;
        this.log.info("findByName()");
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourceName");
        }
        try {
            builder = this.resourceAOHelper.buildResourceSelectsComposable();
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_R_RESC_NAME, QueryConditionOperators.EQUAL, resourceName.trim());
        }
        catch (GenQueryBuilderException e) {
            this.log.error("gen query builder exception", (Throwable)e);
            throw new JargonException("error querying for resources", e);
        }
        try {
            IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query for data object", e);
        }
        catch (GenQueryBuilderException e) {
            this.log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query for data object", e);
        }
        if (resultSet.getResults().size() == 0) {
            messageBuilder = new StringBuilder();
            messageBuilder.append("resource not found for name:");
            messageBuilder.append(resourceName);
            message = messageBuilder.toString();
            this.log.warn(message);
            throw new DataNotFoundException(message);
        }
        if (resultSet.getResults().size() > 1) {
            messageBuilder = new StringBuilder();
            messageBuilder.append("more than one resource found for name:");
            messageBuilder.append(resourceName);
            message = messageBuilder.toString();
            this.log.error(message);
            throw new JargonException(message);
        }
        IRODSQueryResultRow row = resultSet.getFirstResult();
        Resource resource = this.resourceAOHelper.buildResourceFromResultSetRowClassic(row);
        return resource;
    }

    @Override
    public Resource findById(String resourceId) throws JargonException, DataNotFoundException {
        String message;
        StringBuilder messageBuilder;
        IRODSQueryResultSet resultSet;
        IRODSGenQueryBuilder builder;
        this.log.info("findById()");
        if (resourceId == null || resourceId.isEmpty()) {
            throw new IllegalArgumentException("resourceId is null or empty");
        }
        try {
            builder = this.resourceAOHelper.buildResourceSelectsComposable();
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_R_RESC_ID, QueryConditionOperators.EQUAL, resourceId.trim());
        }
        catch (GenQueryBuilderException e) {
            this.log.error("gen query builder exception", (Throwable)e);
            throw new JargonException("error querying for resources", e);
        }
        try {
            IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query for data object", e);
        }
        catch (GenQueryBuilderException e) {
            this.log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query for data object", e);
        }
        if (resultSet.getResults().size() == 0) {
            messageBuilder = new StringBuilder();
            messageBuilder.append("resource not found for id:");
            messageBuilder.append(resourceId);
            message = messageBuilder.toString();
            this.log.warn(message);
            throw new DataNotFoundException(message);
        }
        if (resultSet.getResults().size() > 1) {
            messageBuilder = new StringBuilder();
            messageBuilder.append("more than one resource found for id:");
            messageBuilder.append(resourceId);
            message = messageBuilder.toString();
            this.log.error(message);
            throw new JargonException(message);
        }
        IRODSQueryResultRow row = resultSet.getFirstResult();
        Resource resource = this.resourceAOHelper.buildResourceFromResultSetRowClassic(row);
        return resource;
    }

    @Override
    public List<Resource> findAll() throws JargonException {
        this.log.info("findAll()");
        List<Resource> resources = this.findAllComposable();
        this.log.info("resources:{}", resources);
        return resources;
    }

    private List<Resource> findAllComposable() throws JargonException {
        this.log.info("findAllComposable() - post 4.0 server");
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSQueryResultSet resultSet = null;
        try {
            IRODSGenQueryBuilder builder = this.resourceAOHelper.buildResourceSelectsComposable();
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_R_RESC_NAME, QueryConditionOperators.NOT_EQUAL, "bundleResc");
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query", e);
        }
        catch (GenQueryBuilderException e) {
            this.log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query", e);
        }
        return this.resourceAOHelper.buildResourceListFromResultSetComposable(resultSet);
    }

    @Override
    public Resource getFirstResourceForIRODSFile(IRODSFile irodsFile) throws JargonException, DataNotFoundException {
        this.log.info("getFirstResourceForIRODSFile()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        this.log.info("irodsFile:{}", (Object)irodsFile);
        if (irodsFile.isDirectory()) {
            String msg = "looking for a resource for an IRODSFileImpl, but I the file is a collection:" + irodsFile.getAbsolutePath();
            this.log.error(msg);
            throw new JargonException(msg);
        }
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSQueryResultSet resultSet = null;
        try {
            IRODSGenQueryBuilder builder = this.resourceAOHelper.buildResourceSelectsComposable();
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, irodsFile.getParent());
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_DATA_NAME, QueryConditionOperators.EQUAL, irodsFile.getName());
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query", e);
        }
        catch (GenQueryBuilderException e) {
            this.log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query", e);
        }
        List<Resource> resources = this.resourceAOHelper.buildResourceListFromResultSetClassic(resultSet);
        if (resources.isEmpty()) {
            this.log.warn("no data found");
            throw new DataNotFoundException("no resources found for file:" + irodsFile.getAbsolutePath());
        }
        return resources.get(0);
    }

    @Override
    public List<String> listResourceAndResourceGroupNames() throws JargonException {
        this.log.info("listResourceAndResourceGroupNames()");
        this.log.info("listResourceAndResourceGroupNames()..getting resource names");
        List<String> combined = this.listResourceNames();
        if (this.getIRODSServerProperties().isAtLeastIrods410()) {
            this.log.info("is consortium irods, don't look for resource groups");
            return combined;
        }
        this.log.info("appending resource group names..");
        ResourceGroupAO resourceGroupAO = this.getIRODSAccessObjectFactory().getResourceGroupAO(this.getIRODSAccount());
        combined.addAll(resourceGroupAO.listResourceGroupNames());
        return combined;
    }

    @Override
    public List<String> listResourceNames() throws JargonException {
        ArrayList<String> resourceNames = new ArrayList<String>();
        IRODSQueryResultSet resultSet = null;
        try {
            IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_R_RESC_NAME).addOrderByGenQueryField(RodsGenQueryEnum.COL_R_RESC_NAME, GenQueryOrderByField.OrderByType.ASC);
            if (this.getIRODSServerProperties().isAtLeastIrods410()) {
                builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_R_RESC_PARENT, QueryConditionOperators.EQUAL, "");
            }
            IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(builder.exportIRODSQueryFromBuilder(this.getIRODSAccessObjectFactory().getJargonProperties().getMaxFilesAndDirsQueryMax()), 0);
        }
        catch (JargonQueryException e) {
            this.log.error("jargon query exception getting results", (Throwable)e);
            throw new JargonException(e);
        }
        catch (GenQueryBuilderException e) {
            this.log.error("jargon query exception getting results", (Throwable)e);
            throw new JargonException(e);
        }
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            resourceNames.add(row.getColumn(0));
        }
        return resourceNames;
    }

    @Override
    public List<AvuData> listResourceMetadata(String resourceName) throws JargonException {
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourceName");
        }
        this.log.info("list resource metadata for {}", (Object)resourceName);
        IRODSQueryResultSet resultSet = null;
        try {
            IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_RESC_ATTR_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_RESC_ATTR_VALUE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_RESC_ATTR_UNITS).addConditionAsGenQueryField(RodsGenQueryEnum.COL_R_RESC_NAME, QueryConditionOperators.EQUAL, resourceName);
            IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(builder.exportIRODSQueryFromBuilder(this.getIRODSAccessObjectFactory().getJargonProperties().getMaxFilesAndDirsQueryMax()), 0);
        }
        catch (JargonQueryException e) {
            this.log.error("jargon query exception getting results", (Throwable)e);
            throw new JargonException(e);
        }
        catch (GenQueryBuilderException e) {
            this.log.error("jargon query exception getting results", (Throwable)e);
            throw new JargonException(e);
        }
        return AccessObjectQueryProcessingUtils.buildAvuDataListFromResultSet(resultSet);
    }

    public List<Resource> findDomainByMetadataQuery(List<AVUQueryElement> avuQueryElements) throws JargonQueryException, JargonException {
        return null;
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQuery(List<AVUQueryElement> avuQuery) throws JargonQueryException, JargonException {
        this.log.info("findMetadataValuesByMetadataQuery()");
        if (avuQuery == null || avuQuery.isEmpty()) {
            throw new IllegalArgumentException("null or empty query");
        }
        this.log.info("building a metadata query for: {}", avuQuery);
        IRODSQueryResultSet resultSet = null;
        try {
            IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_R_RESC_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_R_RESC_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_RESC_ATTR_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_RESC_ATTR_VALUE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_RESC_ATTR_UNITS).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_RESC_ATTR_ID);
            for (AVUQueryElement queryElement : avuQuery) {
                this.buildConditionPart(queryElement, builder);
            }
            IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(builder.exportIRODSQueryFromBuilder(this.getIRODSAccessObjectFactory().getJargonProperties().getMaxFilesAndDirsQueryMax()), 0);
        }
        catch (JargonQueryException e) {
            this.log.error("jargon query exception getting results", (Throwable)e);
            throw new JargonException(e);
        }
        catch (GenQueryBuilderException e) {
            this.log.error("jargon query exception getting results", (Throwable)e);
            throw new JargonException(e);
        }
        return this.buildMetaDataAndDomainDatalistFromResultSet(MetaDataAndDomainData.MetadataDomain.RESOURCE, resultSet);
    }

    private List<MetaDataAndDomainData> buildMetaDataAndDomainDatalistFromResultSet(MetaDataAndDomainData.MetadataDomain metaDataDomain, IRODSQueryResultSetInterface irodsQueryResultSet) throws JargonException {
        if (metaDataDomain == null) {
            throw new JargonException("null metaDataDomain");
        }
        if (irodsQueryResultSet == null) {
            throw new JargonException("null irodsQueryResultSet");
        }
        ArrayList<MetaDataAndDomainData> metaDataResults = new ArrayList<MetaDataAndDomainData>();
        for (IRODSQueryResultRow row : irodsQueryResultSet.getResults()) {
            metaDataResults.add(this.buildMetaDataAndDomainDataFromResultSetRow(metaDataDomain, row, irodsQueryResultSet.getTotalRecords()));
        }
        return metaDataResults;
    }

    private MetaDataAndDomainData buildMetaDataAndDomainDataFromResultSetRow(MetaDataAndDomainData.MetadataDomain metadataDomain, IRODSQueryResultRow row, int totalRecordCount) throws JargonException {
        String domainId = row.getColumn(0);
        String domainUniqueName = row.getColumn(1);
        String attributeName = row.getColumn(2);
        String attributeValue = row.getColumn(3);
        String attributeUnits = row.getColumn(4);
        int attributeId = row.getColumnAsIntOrZero(5);
        MetaDataAndDomainData data = MetaDataAndDomainData.instance(metadataDomain, domainId, domainUniqueName, attributeId, attributeName, attributeValue, attributeUnits);
        data.setCount(row.getRecordCount());
        data.setLastResult(row.isLastResult());
        data.setTotalRecords(totalRecordCount);
        this.log.debug("metadataAndDomainData: {}", (Object)data);
        return data;
    }

    private void buildConditionPart(AVUQueryElement queryElement, IRODSGenQueryBuilder builder) {
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.ATTRIBUTE) {
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_META_RESC_ATTR_NAME, QueryConditionOperators.getOperatorFromStringValue(queryElement.getOperator().getOperatorValue()), queryElement.getValue());
        } else if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.VALUE) {
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_META_RESC_ATTR_VALUE, QueryConditionOperators.getOperatorFromStringValue(queryElement.getOperator().getOperatorValue()), queryElement.getValue());
        } else if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.UNITS) {
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_META_RESC_ATTR_UNITS, QueryConditionOperators.getOperatorFromStringValue(queryElement.getOperator().getOperatorValue()), queryElement.getValue());
        }
    }

    @Override
    public void addAVUMetadata(String resourceName, AvuData avuData) throws InvalidResourceException, DuplicateDataException, JargonException {
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resource name");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        this.log.info("adding avu metadata to resource: {}", (Object)resourceName);
        this.log.info("avu: {}", (Object)avuData);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForAddResourceMetadata(resourceName, avuData);
        this.log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-817000") > -1) {
                throw new DataNotFoundException("Target resource was not found, could not add AVU");
            }
            if (je.getMessage().indexOf("-809000") > -1) {
                throw new DuplicateDataException("Duplicate AVU exists, cannot add");
            }
            this.log.error("jargon exception adding AVU metadata", (Throwable)je);
            throw je;
        }
        this.log.debug("metadata added");
    }

    @Override
    public void setAVUMetadata(String resourceName, AvuData avuData) throws InvalidResourceException, JargonException {
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resource name");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        this.log.info("setting avu metadata to resource: {}", (Object)resourceName);
        this.log.info("avu: {}", (Object)avuData);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForSetResourceMetadata(resourceName, avuData);
        this.log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-817000") > -1) {
                throw new DataNotFoundException("Target resource was not found, could not add AVU");
            }
            this.log.error("jargon exception setting AVU metadata", (Throwable)je);
            throw je;
        }
        this.log.debug("metadata set");
    }

    @Override
    public void deleteAVUMetadata(String resourceName, AvuData avuData) throws InvalidResourceException, JargonException {
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resource name");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        this.log.info("delete avu metadata from resource: {}", (Object)resourceName);
        this.log.info("avu: {}", (Object)avuData);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForDeleteResourceMetadata(resourceName, avuData);
        this.log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-817000") > -1) {
                throw new DataNotFoundException("Target resource was not found, could not remove AVU");
            }
            this.log.error("jargon exception removing AVU metadata", (Throwable)je);
            throw je;
        }
        this.log.debug("metadata removed");
    }
}

