/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.irods.jargon.core.pub.io.IRODSFileOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackingIrodsOutputStream
extends OutputStream {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private int byteBufferSizeMax;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private final IRODSFileOutputStream irodsFileOutputStream;
    private long controlByteCount = 0L;
    private long controlBytesIn = 0L;

    public PackingIrodsOutputStream(IRODSFileOutputStream irodsFileOutputStream) {
        if (irodsFileOutputStream == null) {
            throw new IllegalArgumentException("null irodsFileOutputStream");
        }
        this.byteBufferSizeMax = irodsFileOutputStream.getFileIOOperations().getJargonProperties().getPutBufferSize();
        if (this.byteBufferSizeMax <= 0) {
            throw new IllegalStateException("cannot have a zero or negative buffer size");
        }
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.irodsFileOutputStream = irodsFileOutputStream;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.log.debug("write()");
        this.controlBytesIn += (long)len;
        this.log.debug("controlBytesIn:{}", (Object)this.controlBytesIn);
        int projectedLen = this.byteArrayOutputStream.size() + (len - off);
        this.log.info("projectedLen:{}", (Object)projectedLen);
        if (projectedLen < this.byteBufferSizeMax) {
            this.log.debug("less than buffer max so cache until full");
            this.byteArrayOutputStream.write(b, off, len);
        } else {
            this.log.debug("buffer is full, write to irods and reset");
            this.byteArrayOutputStream.write(b, off, len);
            this.flushAndResetBufferStream();
        }
    }

    private void flushAndResetBufferStream() throws IOException {
        if (this.byteArrayOutputStream.size() > 0) {
            this.irodsFileOutputStream.write(this.byteArrayOutputStream.toByteArray());
            this.controlByteCount += (long)this.byteArrayOutputStream.size();
            this.log.debug("controlByteCount:{}", (Object)this.controlByteCount);
            this.byteArrayOutputStream.reset();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buffer = new byte[]{(byte)b};
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.log.info("closing underlying stream");
        if (this.controlByteCount != this.controlBytesIn) {
            throw new IOException("control balance error in stream");
        }
        this.irodsFileOutputStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.log.debug("flush()...see if any bytes are buffered");
        if (this.byteArrayOutputStream.size() > 0) {
            this.log.debug("flushing buffered bytes and resetting");
            this.flushAndResetBufferStream();
            this.log.debug("now flushing the underlying iRODS stream");
            this.irodsFileOutputStream.flush();
        }
    }
}

