/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.Date;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.domain.IRODSDomainObject;

public final class MetaDataAndDomainData
extends IRODSDomainObject {
    private final MetadataDomain metadataDomain;
    private final String domainObjectId;
    private final String domainObjectUniqueName;
    private final int avuId;
    private final long size;
    private final Date createdAt;
    private final Date modifiedAt;
    private final String avuAttribute;
    private final String avuValue;
    private final String avuUnit;

    public static MetaDataAndDomainData instance(MetadataDomain metadataDomain, String domainObjectId, String domainObjectUniqueName, int avuId, String avuAttribute, String avuValue, String avuUnit) throws JargonException {
        return new MetaDataAndDomainData(metadataDomain, domainObjectId, domainObjectUniqueName, 0L, null, null, avuId, avuAttribute, avuValue, avuUnit);
    }

    public static MetaDataAndDomainData instance(MetadataDomain metadataDomain, String domainObjectId, String domainObjectUniqueName, long size, Date createdAt, Date modifiedAt, int avuId, String avuAttribute, String avuValue, String avuUnit) throws JargonException {
        return new MetaDataAndDomainData(metadataDomain, domainObjectId, domainObjectUniqueName, 0L, null, null, avuId, avuAttribute, avuValue, avuUnit);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MetaDataAndDomainData [");
        if (this.metadataDomain != null) {
            builder.append("metadataDomain=");
            builder.append((Object)this.metadataDomain);
            builder.append(", ");
        }
        if (this.domainObjectId != null) {
            builder.append("domainObjectId=");
            builder.append(this.domainObjectId);
            builder.append(", ");
        }
        if (this.domainObjectUniqueName != null) {
            builder.append("domainObjectUniqueName=");
            builder.append(this.domainObjectUniqueName);
            builder.append(", ");
        }
        builder.append("avuId=");
        builder.append(this.avuId);
        builder.append(", size=");
        builder.append(this.size);
        builder.append(", ");
        if (this.createdAt != null) {
            builder.append("createdAt=");
            builder.append(this.createdAt);
            builder.append(", ");
        }
        if (this.modifiedAt != null) {
            builder.append("modifiedAt=");
            builder.append(this.modifiedAt);
            builder.append(", ");
        }
        if (this.avuAttribute != null) {
            builder.append("avuAttribute=");
            builder.append(this.avuAttribute);
            builder.append(", ");
        }
        if (this.avuValue != null) {
            builder.append("avuValue=");
            builder.append(this.avuValue);
            builder.append(", ");
        }
        if (this.avuUnit != null) {
            builder.append("avuUnit=");
            builder.append(this.avuUnit);
        }
        builder.append("]");
        return builder.toString();
    }

    private MetaDataAndDomainData(MetadataDomain metadataDomain, String domainObjectId, String domainObjectUniqueName, long size, Date createdAt, Date modifiedAt, int avuId, String avuAttribute, String avuValue, String avuUnit) throws JargonException {
        if (metadataDomain == null) {
            throw new JargonException("metadataDomain is null");
        }
        if (domainObjectId == null || domainObjectId.isEmpty()) {
            throw new JargonException("domain object id is null or empty");
        }
        if (domainObjectUniqueName == null || domainObjectUniqueName.isEmpty()) {
            throw new JargonException("domain object unique name is null or empty");
        }
        if (avuAttribute == null || avuAttribute.isEmpty()) {
            throw new JargonException("avu attribute is null or empty");
        }
        if (avuValue == null) {
            throw new JargonException("avu value is null");
        }
        if (avuUnit == null) {
            throw new JargonException("avu unit is null");
        }
        this.metadataDomain = metadataDomain;
        this.domainObjectId = domainObjectId;
        this.domainObjectUniqueName = domainObjectUniqueName;
        this.avuId = avuId;
        this.avuAttribute = avuAttribute;
        this.avuValue = avuValue;
        this.avuUnit = avuUnit;
        this.size = size;
        this.modifiedAt = modifiedAt;
        this.createdAt = createdAt;
    }

    public String getDomainObjectId() {
        return this.domainObjectId;
    }

    public String getDomainObjectUniqueName() {
        return this.domainObjectUniqueName;
    }

    public String getAvuAttribute() {
        return this.avuAttribute;
    }

    public String getAvuValue() {
        return this.avuValue;
    }

    public String getAvuUnit() {
        return this.avuUnit;
    }

    public MetadataDomain getMetadataDomain() {
        return this.metadataDomain;
    }

    public int getAvuId() {
        return this.avuId;
    }

    public long getSize() {
        return this.size;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public static enum MetadataDomain {
        RESOURCE,
        USER,
        DATA,
        COLLECTION;

    }
}

