/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.synchronize;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PasswordInput {
    private static final Log LOG = LogFactory.getLog(PasswordInput.class);

    public static String getPassword(String prompt) throws IOException {
        String password = null;
        String javaVers = System.getProperty("java.runtime.version");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to attempt to read password under Java version: " + javaVers));
        }
        String[] versionMajAndMin = javaVers.split("\\.");
        int majorVersion = Integer.parseInt(versionMajAndMin[0]);
        int minorVersion = Integer.parseInt(versionMajAndMin[1]);
        password = majorVersion > 1 || minorVersion >= 6 ? PasswordInput.getPasswordJDK16OrLater(prompt) : PasswordInput.getPasswordBeforeJDK16(prompt);
        return password;
    }

    private static String getPasswordBeforeJDK16(String prompt) throws IOException {
        System.out.print(prompt + ": ");
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(System.in));
        String password = inputReader.readLine();
        return password;
    }

    private static String getPasswordJDK16OrLater(String prompt) throws IOException {
        String password = null;
        try {
            Class<?> consoleClass = Class.forName("java.io.Console");
            Method consoleReadPassword = consoleClass.getDeclaredMethod("readPassword", new Class[0]);
            Method consoleMethod = System.class.getDeclaredMethod("console", new Class[0]);
            Object consoleObject = consoleMethod.invoke(null, new Object[0]);
            if (consoleObject == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"java.io.Console using reflection returned null, so that password will be fetched using the pre-JDK 1.6 version");
                }
                password = PasswordInput.getPasswordBeforeJDK16(prompt);
            } else {
                System.out.println(prompt + " (typing will be hidden):");
                Object passwordObj = consoleReadPassword.invoke(consoleObject, new Object[0]);
                char[] passwordChars = (char[])passwordObj;
                password = String.valueOf(passwordChars);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Encountered trouble using relection to generate java.io.Console class");
        }
        return password;
    }
}

