/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import net.schmizz.sshj.sftp.FileAttributes;

public class SFTPTimestampFeature
extends DefaultTimestampFeature
implements Timestamp {
    private final SFTPSession session;

    public SFTPTimestampFeature(SFTPSession session) {
        this.session = session;
    }

    public void setTimestamp(Path file, TransferStatus status) throws BackgroundException {
        try {
            FileAttributes attrs = new FileAttributes.Builder().withAtimeMtime(System.currentTimeMillis() / 1000L, status.getTimestamp() / 1000L).build();
            this.session.sftp().setAttributes(file.getAbsolute(), attrs);
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Cannot change timestamp of {0}", e, file);
        }
    }
}

