/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.shared.DefaultFindFeature;
import com.github.sardine.impl.SardineException;
import com.github.sardine.impl.handler.ExistsResponseHandler;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;

public class DAVFindFeature
implements Find {
    private final DAVSession session;
    private Cache<Path> cache = PathCache.empty();

    public DAVFindFeature(DAVSession session) {
        this.session = session;
    }

    public boolean find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return true;
        }
        try {
            try {
                try {
                    HttpHead request = new HttpHead(new DAVPathEncoder().encode(file));
                    for (Header header : this.headers()) {
                        request.addHeader(header);
                    }
                    return (Boolean)((DAVClient)((Object)this.session.getClient())).execute((HttpRequestBase)request, new ExistsResponseHandler());
                }
                catch (SardineException e) {
                    throw new DAVExceptionMappingService().map("Failure to read attributes of {0}", e, file);
                }
                catch (IOException e) {
                    throw new HttpExceptionMappingService().map(e, file);
                }
            }
            catch (AccessDeniedException | InteroperabilityException e) {
                return new DefaultFindFeature((Session)this.session).withCache(this.cache).find(file);
            }
        }
        catch (AccessDeniedException e) {
            return true;
        }
        catch (LoginFailureException | NotfoundException e) {
            return false;
        }
    }

    public Set<Header> headers() {
        return Collections.emptySet();
    }

    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

