/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

public class ConnectionProgressStatus {
    private final long byteCount;
    private final CallbackType callbackType;

    public long getByteCount() {
        return this.byteCount;
    }

    public CallbackType getCallbackType() {
        return this.callbackType;
    }

    public static ConnectionProgressStatus instanceForSend(long byteCount) {
        return new ConnectionProgressStatus(CallbackType.SEND_PROGRESS, byteCount);
    }

    public static ConnectionProgressStatus instanceForReceive(long byteCount) {
        return new ConnectionProgressStatus(CallbackType.RECEIVE_PROGRESS, byteCount);
    }

    private ConnectionProgressStatus(CallbackType callbackType, long byteCount) {
        if (callbackType == null) {
            throw new IllegalArgumentException("null callbackType");
        }
        this.callbackType = callbackType;
        this.byteCount = byteCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionProgressStatus");
        sb.append("\n   callbackType:");
        sb.append((Object)this.callbackType);
        sb.append("\n   byteCount:");
        sb.append(this.byteCount);
        return sb.toString();
    }

    public static enum CallbackType {
        SEND_PROGRESS,
        RECEIVE_PROGRESS,
        OPERATIONAL_MESSAGE;

    }
}

