/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.IOException;
import java.io.InputStream;
import org.irods.jargon.core.connection.ConnectionProgressStatus;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;

public class ByteCountingCallbackInputStreamWrapper
extends InputStream {
    private final ConnectionProgressStatusListener connectionProgressStatusListener;
    private final InputStream inputStream;

    public ByteCountingCallbackInputStreamWrapper(ConnectionProgressStatusListener connectionProgressStatusListener, InputStream inputStream) {
        if (connectionProgressStatusListener == null) {
            throw new IllegalArgumentException("null connectionProgressStatusListener");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("null inputStream");
        }
        this.connectionProgressStatusListener = connectionProgressStatusListener;
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.inputStream.read(b, off, len);
        this.callbackOnRead(read);
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.inputStream.read(b);
        this.callbackOnRead(read);
        return read;
    }

    private void callbackOnRead(int read) {
        if (read > 0) {
            ConnectionProgressStatus status = ConnectionProgressStatus.instanceForReceive(read);
            this.connectionProgressStatusListener.connectionProgressStatusCallback(status);
        }
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }
}

