/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.handler;

import ch.iterate.openstack.swift.Response;
import ch.iterate.openstack.swift.exception.AuthorizationException;
import ch.iterate.openstack.swift.exception.ContainerNotFoundException;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.ContainerInfo;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

public class ContainerInfoHandler
implements ResponseHandler<ContainerInfo> {
    private Region region;
    private String container;

    public ContainerInfoHandler(Region region, String container) {
        this.region = region;
        this.container = container;
    }

    public ContainerInfo handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        if (response.getStatusLine().getStatusCode() == 204 || response.getStatusLine().getStatusCode() == 200) {
            return new ContainerInfo(this.region, this.container, this.getContainerObjectCount(response), this.getContainerBytesUsed(response));
        }
        if (response.getStatusLine().getStatusCode() == 404) {
            throw new ContainerNotFoundException(new Response(response));
        }
        if (response.getStatusLine().getStatusCode() == 401) {
            throw new AuthorizationException(new Response(response));
        }
        throw new GenericException(new Response(response));
    }

    private Integer getContainerObjectCount(HttpResponse response) {
        Header contCountHeader = response.getFirstHeader("X-Container-Object-Count");
        if (contCountHeader != null) {
            return Integer.parseInt(contCountHeader.getValue());
        }
        return null;
    }

    private Long getContainerBytesUsed(HttpResponse response) {
        Header contBytesUsedHeader = response.getFirstHeader("X-Container-Bytes-Used");
        if (contBytesUsedHeader != null) {
            return Long.parseLong(contBytesUsedHeader.getValue());
        }
        return null;
    }
}

