/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.io;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;

public class HttpMethodReleaseInputStream
extends CountingInputStream {
    private static final Logger log = Logger.getLogger(HttpMethodReleaseInputStream.class.getName());
    private HttpResponse response;

    public HttpMethodReleaseInputStream(HttpResponse response) throws IOException {
        super(response.getEntity().getContent());
        this.response = response;
    }

    public void close() throws IOException {
        if (this.response instanceof CloseableHttpResponse) {
            long read = this.getByteCount();
            if (read == this.response.getEntity().getContentLength()) {
                super.close();
            } else {
                if (log.isLoggable(Level.WARNING)) {
                    log.warning(String.format("Abort connection for response %s", this.response));
                }
                ((CloseableHttpResponse)this.response).close();
            }
        } else {
            super.close();
        }
    }
}

